/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.change;

import java.util.ArrayList;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.versions.change.CompositeVersionChanger;
import org.codehaus.mojo.versions.change.DependencyVersionChanger;
import org.codehaus.mojo.versions.change.ParentVersionChanger;
import org.codehaus.mojo.versions.change.PluginVersionChanger;
import org.codehaus.mojo.versions.change.ProjectVersionChanger;
import org.codehaus.mojo.versions.change.VersionChanger;
import org.codehaus.mojo.versions.rewriting.MutableXMLStreamReader;

public class VersionChangerFactory {
    private Model model = null;
    private MutableXMLStreamReader pom = null;
    private Log log = null;

    public synchronized Model getModel() {
        return this.model;
    }

    public synchronized void setModel(Model model) {
        this.model = model;
    }

    public synchronized MutableXMLStreamReader getPom() {
        return this.pom;
    }

    public synchronized void setPom(MutableXMLStreamReader pom) {
        this.pom = pom;
    }

    public synchronized Log getLog() {
        return this.log;
    }

    public synchronized void setLog(Log log) {
        this.log = log;
    }

    private synchronized void checkState() {
        if (this.model == null) {
            throw new IllegalStateException("Model has not been specified");
        }
        if (this.pom == null) {
            throw new IllegalStateException("Pom has not been specified");
        }
        if (this.log == null) {
            throw new IllegalStateException("Log has not been specified");
        }
    }

    public synchronized VersionChanger newPluginVersionChanger() {
        this.checkState();
        return new PluginVersionChanger(this.model, this.pom, this.log);
    }

    public synchronized VersionChanger newDependencyVersionChanger() {
        this.checkState();
        return new DependencyVersionChanger(this.model, this.pom, this.log);
    }

    public synchronized VersionChanger newProjectVersionChanger() {
        this.checkState();
        return new ProjectVersionChanger(this.model, this.pom, this.log);
    }

    public synchronized VersionChanger newParentVersionChanger() {
        this.checkState();
        return new ParentVersionChanger(this.model, this.pom, this.log);
    }

    public synchronized VersionChanger newVersionChanger() {
        this.checkState();
        VersionChanger[] delegates = new VersionChanger[]{this.newParentVersionChanger(), this.newProjectVersionChanger(), this.newDependencyVersionChanger(), this.newPluginVersionChanger()};
        return new CompositeVersionChanger(delegates);
    }

    public synchronized VersionChanger newVersionChanger(boolean processParent, boolean processProject, boolean processDependencies, boolean processPlugins) {
        this.checkState();
        ArrayList<VersionChanger> delegates = new ArrayList<VersionChanger>();
        if (processParent) {
            delegates.add(this.newParentVersionChanger());
        }
        if (processProject) {
            delegates.add(this.newProjectVersionChanger());
        }
        if (processDependencies) {
            delegates.add(this.newDependencyVersionChanger());
        }
        if (processPlugins) {
            delegates.add(this.newPluginVersionChanger());
        }
        return new CompositeVersionChanger(delegates);
    }
}

