/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.codehaus.mojo.versions.api.ArtifactAssociation;
import org.codehaus.mojo.versions.api.DefaultArtifactAssociation;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.ordering.VersionComparator;

public class PropertyVersionsBuilder {
    private final String name;
    private final String profileId;
    private final Set<ArtifactAssociation> associations;
    private final VersionsHelper helper;
    private final Map<String, Boolean> upperBounds = new LinkedHashMap<String, Boolean>();
    private final Map<String, Boolean> lowerBounds = new LinkedHashMap<String, Boolean>();
    private ArtifactVersion currentVersion;
    private VersionRange currentVersionRange;

    PropertyVersionsBuilder(String profileId, String name, VersionsHelper helper) {
        this.profileId = profileId;
        this.name = name;
        this.associations = new TreeSet<ArtifactAssociation>();
        this.helper = helper;
    }

    public PropertyVersionsBuilder withAssociation(Artifact artifact, boolean usePluginRepositories) {
        this.associations.add(new DefaultArtifactAssociation(artifact, usePluginRepositories));
        return this;
    }

    public void clearAssociations() {
        this.associations.clear();
    }

    public boolean isAssociated() {
        return !this.associations.isEmpty();
    }

    public ArtifactAssociation[] getAssociations() {
        return this.associations.toArray(new ArtifactAssociation[0]);
    }

    public PropertyVersions build() throws VersionRetrievalException {
        PropertyVersions instance = new PropertyVersions(this.profileId, this.name, this.helper, this.associations);
        instance.setCurrentVersion(this.currentVersion);
        instance.setCurrentVersionRange(this.currentVersionRange);
        return instance;
    }

    public String getName() {
        return this.name;
    }

    public String getVersionRange() {
        PropertyVersionComparator comparator = new PropertyVersionComparator();
        if (this.lowerBounds.isEmpty() && this.upperBounds.isEmpty()) {
            return null;
        }
        ArtifactVersion lowerBound = null;
        boolean includeLower = true;
        for (Map.Entry<String, Boolean> entry : this.lowerBounds.entrySet()) {
            ArtifactVersion candidate = this.helper.createArtifactVersion(entry.getKey());
            if (lowerBound == null) {
                lowerBound = candidate;
                includeLower = entry.getValue();
                continue;
            }
            int n = comparator.compare(lowerBound, candidate);
            if (n > 0) {
                lowerBound = candidate;
                includeLower = entry.getValue();
                continue;
            }
            if (n != 0) continue;
            includeLower = includeLower && entry.getValue() != false;
        }
        ArtifactVersion upperBound = null;
        boolean includeUpper = true;
        for (Map.Entry entry : this.upperBounds.entrySet()) {
            ArtifactVersion candidate = this.helper.createArtifactVersion((String)entry.getKey());
            if (upperBound == null) {
                upperBound = candidate;
                includeUpper = (Boolean)entry.getValue();
                continue;
            }
            int result = comparator.compare(upperBound, candidate);
            if (result < 0) {
                upperBound = candidate;
                includeUpper = (Boolean)entry.getValue();
                continue;
            }
            if (result != 0) continue;
            includeUpper = includeUpper && (Boolean)entry.getValue() != false;
        }
        StringBuilder buf = new StringBuilder();
        if (includeLower) {
            buf.append('[');
        } else {
            buf.append('(');
        }
        if (lowerBound != null) {
            buf.append(lowerBound);
        }
        buf.append(',');
        if (upperBound != null) {
            buf.append(upperBound);
        }
        if (includeUpper) {
            buf.append(']');
        } else {
            buf.append(')');
        }
        return buf.toString();
    }

    public PropertyVersionsBuilder withLowerBound(String lowerBound, boolean includeLower) {
        Boolean value = this.lowerBounds.get(lowerBound);
        value = value == null ? Boolean.valueOf(includeLower) : Boolean.valueOf(includeLower && value != false);
        this.lowerBounds.put(lowerBound, value);
        return this;
    }

    public PropertyVersionsBuilder withUpperBound(String upperBound, boolean includeUpper) {
        Boolean value = this.upperBounds.get(upperBound);
        value = value == null ? Boolean.valueOf(includeUpper) : Boolean.valueOf(includeUpper && value != false);
        this.upperBounds.put(upperBound, value);
        return this;
    }

    private VersionComparator[] lookupComparators() {
        return (VersionComparator[])this.associations.stream().map(association -> this.helper.getVersionComparator(association.getArtifact())).distinct().toArray(VersionComparator[]::new);
    }

    public PropertyVersionsBuilder withCurrentVersion(ArtifactVersion currentVersion) {
        this.currentVersion = currentVersion;
        return this;
    }

    public PropertyVersionsBuilder withCurrentVersionRange(VersionRange currentVersionRange) {
        this.currentVersionRange = currentVersionRange;
        return this;
    }

    private final class PropertyVersionComparator
    implements Comparator<ArtifactVersion> {
        private PropertyVersionComparator() {
        }

        @Override
        public int compare(ArtifactVersion v1, ArtifactVersion v2) {
            return this.innerCompare(v1, v2);
        }

        private int innerCompare(ArtifactVersion v1, ArtifactVersion v2) {
            if (!PropertyVersionsBuilder.this.isAssociated()) {
                throw new IllegalStateException("Cannot compare versions for a property with no associations");
            }
            VersionComparator[] comparators = PropertyVersionsBuilder.this.lookupComparators();
            assert (comparators.length >= 1) : "we have at least one association => at least one comparator";
            int result = comparators[0].compare(v1, v2);
            for (int i = 1; i < comparators.length; ++i) {
                int alt = comparators[i].compare(v1, v2);
                if ((result == alt || result < 0 || alt >= 0) && (result > 0 || alt <= 0)) continue;
                throw new IllegalStateException("Property " + PropertyVersionsBuilder.this.name + " is associated with multiple artifacts and these artifacts use different version sorting rules and these rules are effectively incompatible for the two of versions being compared.\nFirst rule says compare(\"" + v1 + "\", \"" + v2 + "\") = " + result + "\nSecond rule says compare(\"" + v1 + "\", \"" + v2 + "\") = " + alt);
            }
            return result;
        }
    }
}

