/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.utils;

import java.util.Optional;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.versions.api.Segment;

public class SegmentUtils {
    public static Optional<Segment> determineUnchangedSegment(boolean allowMajorUpdates, boolean allowMinorUpdates, boolean allowIncrementalUpdates, Log log) {
        Optional<Segment> unchangedSegment;
        if (log != null && !allowIncrementalUpdates) {
            log.info((CharSequence)"Assuming allowMinorUpdates false because allowIncrementalUpdates is false.");
        }
        if (log != null && !allowMinorUpdates) {
            log.info((CharSequence)"Assuming allowMajorUpdates false because allowMinorUpdates is false.");
        }
        Optional<Object> optional = allowMajorUpdates && allowMinorUpdates && allowIncrementalUpdates ? Optional.empty() : (allowMinorUpdates && allowIncrementalUpdates ? Optional.of(Segment.MAJOR) : (unchangedSegment = allowIncrementalUpdates ? Optional.of(Segment.MINOR) : Optional.of(Segment.INCREMENTAL)));
        if (log != null && log.isDebugEnabled()) {
            log.debug((CharSequence)(unchangedSegment.map(s -> Segment.of(s.value() + 1).toString()).orElse("ALL") + " version changes allowed"));
        }
        return unchangedSegment;
    }
}

