/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

public class UseReleasesMojo
extends AbstractVersionsDependencyUpdaterMojo {
    private Boolean allowRangeMatching;
    private Boolean failIfNotReplaced;
    public final Pattern matchSnapshotRegex = Pattern.compile("^(.+)-((SNAPSHOT)|(\\d{8}\\.\\d{6}-\\d+))$");

    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        try {
            if (this.getProject().getDependencyManagement() != null && this.isProcessingDependencyManagement()) {
                this.useReleases(pom, this.getProject().getDependencyManagement().getDependencies());
            }
            if (this.isProcessingDependencies()) {
                this.useReleases(pom, this.getProject().getDependencies());
            }
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void useReleases(ModifiedPomXMLEventReader pom, Collection dependencies) throws XMLStreamException, MojoExecutionException, ArtifactMetadataRetrievalException {
        for (Dependency dep : dependencies) {
            if (this.isExcludeReactor() && this.isProducedByReactor(dep)) {
                this.getLog().info((CharSequence)("Ignoring reactor dependency: " + this.toString(dep)));
                continue;
            }
            String version = dep.getVersion();
            Matcher versionMatcher = this.matchSnapshotRegex.matcher(version);
            if (!versionMatcher.matches()) continue;
            String releaseVersion = versionMatcher.group(1);
            Artifact artifact = this.toArtifact(dep);
            if (!this.isIncluded(artifact)) continue;
            this.getLog().debug((CharSequence)("Looking for a release of " + this.toString(dep)));
            ArtifactVersions versions = this.getHelper().lookupArtifactVersions(artifact, false);
            if (!this.allowRangeMatching.booleanValue()) {
                if (versions.containsVersion(releaseVersion)) {
                    if (!PomHelper.setDependencyVersion(pom, dep.getGroupId(), dep.getArtifactId(), version, releaseVersion)) continue;
                    this.getLog().info((CharSequence)("Updated " + this.toString(dep) + " to version " + releaseVersion));
                    continue;
                }
                if (!this.failIfNotReplaced.booleanValue()) continue;
                throw new NoSuchElementException("No matching release of " + this.toString(dep) + " found for update.");
            }
            Object finalVersion = null;
            for (ArtifactVersion proposedVersion : versions.getVersions(false)) {
                if (!proposedVersion.toString().startsWith(releaseVersion)) continue;
                this.getLog().debug((CharSequence)("Found matching version for " + this.toString(dep) + " to version " + releaseVersion));
                finalVersion = proposedVersion;
            }
            if (finalVersion != null) {
                if (!PomHelper.setDependencyVersion(pom, dep.getGroupId(), dep.getArtifactId(), version, finalVersion.toString())) continue;
                this.getLog().info((CharSequence)("Updated " + this.toString(dep) + " to version " + finalVersion.toString()));
                continue;
            }
            this.getLog().info((CharSequence)("No matching release of " + this.toString(dep) + " to update via rangeMatching."));
            if (!this.failIfNotReplaced.booleanValue()) continue;
            throw new NoSuchElementException("No matching release of " + this.toString(dep) + " found for update via rangeMatching.");
        }
    }
}

