/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsDisplayMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.internal.DefaultResolverAdapter;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.filtering.DependencyFilter;
import org.codehaus.mojo.versions.internal.DependencyUpdatesLoggingHelper;
import org.codehaus.mojo.versions.rewriting.MutableXMLStreamReader;
import org.codehaus.mojo.versions.rule.RuleService;
import org.codehaus.mojo.versions.rule.RulesServiceBuilder;
import org.codehaus.mojo.versions.utils.ArtifactFactory;
import org.codehaus.mojo.versions.utils.DependencyComparator;
import org.codehaus.mojo.versions.utils.MavenProjectUtils;
import org.codehaus.mojo.versions.utils.SegmentUtils;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="display-dependency-updates", threadSafe=true)
public class DisplayDependencyUpdatesMojo
extends AbstractVersionsDisplayMojo {
    @Parameter(property="processDependencyManagement", defaultValue="true")
    protected boolean processDependencyManagement = true;
    @Parameter(property="processDependencyManagementTransitive", defaultValue="true")
    protected boolean processDependencyManagementTransitive = true;
    @Parameter(property="showVersionless", defaultValue="true")
    protected boolean showVersionless = true;
    @Parameter(property="dependencyManagementIncludes", defaultValue="*")
    private List<String> dependencyManagementIncludes;
    @Parameter(property="dependencyManagementExcludes")
    private List<String> dependencyManagementExcludes;
    @Parameter(property="processDependencies", defaultValue="true")
    protected boolean processDependencies;
    @Parameter(property="dependencyIncludes", defaultValue="*")
    protected List<String> dependencyIncludes;
    @Parameter(property="dependencyExcludes")
    protected List<String> dependencyExcludes;
    @Parameter(property="processPluginDependencies", defaultValue="true")
    private boolean processPluginDependencies;
    @Parameter(property="processPluginDependenciesInPluginManagement", defaultValue="true")
    private boolean processPluginDependenciesInPluginManagement;
    @Parameter(property="allowMajorUpdates", defaultValue="true")
    protected boolean allowMajorUpdates = true;
    @Parameter(property="allowMinorUpdates", defaultValue="true")
    protected boolean allowMinorUpdates = true;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    protected boolean allowIncrementalUpdates = true;
    @Parameter(property="verbose", defaultValue="false")
    protected boolean verbose;
    @Parameter(property="pluginDependencyIncludes", defaultValue="*")
    private List<String> pluginDependencyIncludes;
    @Parameter(property="pluginDependencyExcludes")
    private List<String> pluginDependencyExcludes;
    @Parameter(property="pluginManagementDependencyIncludes", defaultValue="*")
    private List<String> pluginManagementDependencyIncludes;
    @Parameter(property="pluginManagementDependencyExcludes")
    private List<String> pluginManagementDependencyExcludes;
    @Parameter(property="allowSnapshots", defaultValue="false")
    protected boolean allowSnapshots;

    @Inject
    public DisplayDependencyUpdatesMojo(ArtifactFactory artifactFactory, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) throws MojoExecutionException {
        super(artifactFactory, repositorySystem, wagonMap, changeRecorders);
    }

    @Override
    protected boolean getAllowSnapshots() {
        return this.allowSnapshots;
    }

    static boolean dependenciesMatch(Dependency dependency, Dependency managedDependency) {
        if (!Objects.equals(managedDependency.getGroupId(), dependency.getGroupId())) {
            return false;
        }
        if (!Objects.equals(managedDependency.getArtifactId(), dependency.getArtifactId())) {
            return false;
        }
        if (managedDependency.getScope() != null && !Objects.equals(managedDependency.getScope(), dependency.getScope())) {
            return false;
        }
        if (managedDependency.getClassifier() != null && !Objects.equals(managedDependency.getClassifier(), dependency.getClassifier())) {
            return false;
        }
        return managedDependency.getVersion() == null || Objects.equals(managedDependency.getVersion(), dependency.getVersion());
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution");
            return;
        }
        this.logInit();
        this.validateInput();
        DefaultResolverAdapter resolverAdapter = new DefaultResolverAdapter(this.artifactFactory, this.repositorySystem, this.getLog(), this.session);
        RuleService ruleService = new RulesServiceBuilder().withMavenSession(this.session).withWagonMap(this.wagonMap).withServerId(this.serverId).withRulesUri(this.rulesUri).withRuleSet(this.ruleSet).withIgnoredVersions((Collection)this.ignoredVersions).withLog(this.getLog()).build();
        Optional unchangedSegment = SegmentUtils.determineUnchangedSegment((boolean)this.allowMajorUpdates, (boolean)this.allowMinorUpdates, (boolean)this.allowIncrementalUpdates, (Log)this.getLog());
        DependencyUpdatesLoggingHelper loggingHelper = new DependencyUpdatesLoggingHelper(this.getProject(), this.getLog(), this.artifactFactory, ruleService, unchangedSegment, this.allowSnapshots, 72 + this.getOutputLineWidthOffset(), this.verbose);
        try {
            SortedMap updates;
            Set dependencyManagement = this.processDependencyManagement ? DependencyFilter.filterDependencies((Collection)MavenProjectUtils.extractDependenciesFromDependencyManagement((MavenProject)this.getProject(), (boolean)this.processDependencyManagementTransitive, (Log)this.getLog()), this.dependencyManagementIncludes, this.dependencyManagementExcludes, (String)"Dependency Management", (Log)this.getLog()).stream().filter(d -> d.getVersion() != null).collect(Collectors.toSet()) : Collections.emptySet();
            Set dependencies = this.processDependencies ? DependencyFilter.filterDependencies((Collection)this.getProject().getDependencies().stream().filter(dep -> dependencyManagement.stream().noneMatch(depMan -> DisplayDependencyUpdatesMojo.dependenciesMatch(dep, depMan))).filter(dep -> this.showVersionless || MavenProjectUtils.dependencyVersionLocalToReactor((Dependency)dep)).collect(Collectors.toSet()), this.dependencyIncludes, this.dependencyExcludes, (String)"Dependencies", (Log)this.getLog()).stream().filter(d -> d.getVersion() != null).collect(Collectors.toSet()) : Collections.emptySet();
            SortedMap dependencyArtifactVersionsMap = resolverAdapter.resolveDependencyVersions((Collection)Stream.concat(dependencyManagement.stream(), dependencies.stream()).collect(Collectors.toSet()), false, true);
            if (this.processDependencies) {
                this.logUpdates(loggingHelper, dependencies.stream().collect(Collectors.toMap(Function.identity(), dependencyArtifactVersionsMap::get, (v1, v2) -> v1, () -> new TreeMap(DependencyComparator.INSTANCE))), "Dependencies");
            }
            if (this.processDependencyManagement) {
                this.logUpdates(loggingHelper, dependencyManagement.stream().collect(Collectors.toMap(Function.identity(), dependencyArtifactVersionsMap::get, (v1, v2) -> v1, () -> new TreeMap(DependencyComparator.INSTANCE))), "Dependency Management");
            }
            if (this.processPluginDependenciesInPluginManagement) {
                updates = resolverAdapter.resolveDependencyVersions((Collection)DependencyFilter.filterDependencies((Collection)MavenProjectUtils.extractPluginDependenciesFromPluginsInPluginManagement((MavenProject)this.getProject()), this.pluginManagementDependencyIncludes, this.pluginManagementDependencyExcludes, (String)"Plugin Management Dependencies", (Log)this.getLog()).stream().filter(d -> d.getVersion() != null).collect(Collectors.toSet()), false, true);
                this.logUpdates(loggingHelper, updates, "pluginManagement of plugins");
            }
            if (this.processPluginDependencies) {
                updates = resolverAdapter.resolveDependencyVersions((Collection)DependencyFilter.filterDependencies((Collection)MavenProjectUtils.extractDependenciesFromPlugins((MavenProject)this.getProject()), this.pluginDependencyIncludes, this.pluginDependencyExcludes, (String)"Plugin Dependencies", (Log)this.getLog()).stream().filter(d -> d.getVersion() != null).collect(Collectors.toSet()), true, false);
                this.logUpdates(loggingHelper, updates, "Plugin Dependencies");
            }
        }
        catch (VersionRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    @Override
    protected void validateInput() throws MojoExecutionException {
        DisplayDependencyUpdatesMojo.validateGAVList(this.dependencyIncludes, 6, "dependencyIncludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.dependencyExcludes, 6, "dependencyExcludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.dependencyManagementIncludes, 6, "dependencyManagementIncludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.dependencyManagementExcludes, 6, "dependencyManagementExcludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.pluginDependencyIncludes, 3, "pluginDependencyIncludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.pluginDependencyExcludes, 3, "pluginDependencyExcludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.pluginManagementDependencyIncludes, 3, "pluginManagementDependencyIncludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.pluginManagementDependencyExcludes, 3, "pluginManagementDependencyExcludes");
    }

    static void validateGAVList(List<String> gavList, int numSections, String argumentName) throws MojoExecutionException {
        if (gavList != null && gavList.stream().anyMatch(gav -> StringUtils.countMatches((CharSequence)gav, (CharSequence)":") >= numSections)) {
            throw new MojoExecutionException(argumentName + " should not contain more than 6 segments");
        }
    }

    private void logUpdates(DependencyUpdatesLoggingHelper loggingHelper, SortedMap<Dependency, ArtifactVersions> versionMap, String section) {
        DependencyUpdatesLoggingHelper.DependencyUpdatesResult updates = loggingHelper.getDependencyUpdates(versionMap);
        if (this.verbose) {
            if (updates.getUsingLatest().isEmpty()) {
                if (!updates.getWithUpdates().isEmpty()) {
                    this.logLine(false, "No dependencies in " + section + " are using the newest version.");
                    this.logLine(false, "");
                }
            } else {
                this.logLine(false, "The following dependencies in " + section + " are using the newest version:");
                updates.getUsingLatest().forEach(s -> this.logLine(false, (String)s));
                this.logLine(false, "");
            }
        }
        if (updates.getWithUpdates().isEmpty()) {
            if (!updates.getUsingLatest().isEmpty()) {
                this.logLine(false, "No dependencies in " + section + " have newer versions.");
                this.logLine(false, "");
            }
        } else {
            this.logLine(false, "The following dependencies in " + section + " have newer versions:");
            updates.getWithUpdates().forEach(s -> this.logLine(false, (String)s));
            this.logLine(false, "");
        }
    }

    @Override
    protected void update(MutableXMLStreamReader pom) {
    }
}

