/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractDependencyUpdatesReport;
import org.codehaus.mojo.versions.reporting.ReportRendererFactory;
import org.codehaus.mojo.versions.utils.ArtifactFactory;
import org.codehaus.plexus.i18n.I18N;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="dependency-updates-report", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class DependencyUpdatesReport
extends AbstractDependencyUpdatesReport {
    @Inject
    protected DependencyUpdatesReport(I18N i18n, ArtifactFactory artifactFactory, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, ReportRendererFactory rendererFactory) {
        super(i18n, artifactFactory, repositorySystem, wagonMap, rendererFactory);
    }

    @Override
    protected void populateDependencies(Set<Dependency> dependenciesCollector) {
        this.getLog().debug((CharSequence)String.format("Collecting dependencies for project %s", this.getProject().getName()));
        dependenciesCollector.addAll(this.getProject().getDependencies());
    }

    @Override
    protected void populateDependencyManagement(Set<Dependency> dependencyManagementCollector) throws MavenReportException {
        if (this.hasDependencyManagement(this.getProject())) {
            this.getLog().debug((CharSequence)String.format("Collecting managed dependencies for project %s", this.getProject().getName()));
            this.handleDependencyManagementTransitive(this.getProject(), dependencyManagementCollector);
        }
    }

    public String getOutputPath() {
        return "dependency-updates-report";
    }
}

