/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.artifact.filter.PatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.ScopeArtifactFilter;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.api.recording.DependencyChangeRecord;
import org.codehaus.mojo.versions.recording.DefaultDependencyChangeRecord;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.DependencyBuilder;
import org.codehaus.mojo.versions.utils.DependencyComparator;

public abstract class AbstractVersionsDependencyUpdaterMojo
extends AbstractVersionsUpdaterMojo {
    private static final String END_RANGE_CHARS = "])";
    private static final String START_RANGE_CHARS = "[(";
    protected static final Pattern SNAPSHOT_REGEX = Pattern.compile("^(.+)-((SNAPSHOT)|(\\d{8}\\.\\d{6}-\\d+))$");
    @Parameter(property="includes")
    private String includesList = null;
    @Parameter(property="excludes")
    private String excludesList = null;
    @Parameter
    private String[] includes = null;
    @Parameter
    private String[] excludes = null;
    @Parameter(property="scope")
    private String scope = null;
    @Parameter(property="processDependencies", defaultValue="true")
    private boolean processDependencies = true;
    @Parameter(property="processDependencyManagement", defaultValue="true")
    private boolean processDependencyManagement = true;
    @Parameter(property="processParent", defaultValue="false")
    private boolean processParent = false;
    private PatternIncludesArtifactFilter includesFilter;
    private PatternExcludesArtifactFilter excludesFilter;
    @Parameter(property="excludeReactor", defaultValue="true")
    private boolean excludeReactor = true;

    @Inject
    protected AbstractVersionsDependencyUpdaterMojo(RepositorySystem repositorySystem, org.eclipse.aether.RepositorySystem aetherRepositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) {
        super(repositorySystem, aetherRepositorySystem, wagonMap, changeRecorders);
    }

    public boolean isProcessingDependencies() {
        return this.processDependencies;
    }

    public boolean isProcessingDependencyManagement() {
        return this.processDependencyManagement;
    }

    public boolean isProcessingParent() {
        return this.processParent;
    }

    public boolean isExcludeReactor() {
        return this.excludeReactor;
    }

    protected boolean isHandledByProperty(Dependency dependency) {
        String version = dependency.getVersion();
        return version != null && version.startsWith("${");
    }

    protected Artifact findArtifact(Dependency dependency) {
        if (this.getProject().getDependencyArtifacts() == null) {
            return null;
        }
        for (Artifact artifact : this.getProject().getDependencyArtifacts()) {
            if (!this.compare(artifact, dependency)) continue;
            return artifact;
        }
        return null;
    }

    protected Artifact toArtifact(Dependency dependency) throws MojoExecutionException {
        Artifact artifact = this.findArtifact(dependency);
        if (artifact == null) {
            return this.getHelper().createDependencyArtifact(dependency);
        }
        return artifact;
    }

    protected Artifact toArtifact(Parent model) throws MojoExecutionException {
        return this.toArtifact(DependencyBuilder.newBuilder().withGroupId(model.getGroupId()).withArtifactId(model.getArtifactId()).withVersion(model.getVersion()).withType("pom").withScope("compile").build());
    }

    protected Dependency getParentDependency() {
        return DependencyBuilder.newBuilder().withGroupId(this.getProject().getParent().getGroupId()).withArtifactId(this.getProject().getParent().getArtifactId()).withVersion(this.getProject().getParent().getVersion()).withType("pom").build();
    }

    protected String toString(MavenProject project) {
        StringBuilder buf = new StringBuilder();
        buf.append(project.getGroupId());
        buf.append(':');
        buf.append(project.getArtifactId());
        if (project.getVersion() != null && project.getVersion().length() > 0) {
            buf.append(":");
            buf.append(project.getVersion());
        }
        return buf.toString();
    }

    protected String toString(Dependency d) {
        StringBuilder buf = new StringBuilder();
        buf.append(d.getGroupId());
        buf.append(':');
        buf.append(d.getArtifactId());
        if (d.getType() != null && d.getType().length() > 0) {
            buf.append(':');
            buf.append(d.getType());
        } else {
            buf.append(":jar");
        }
        if (d.getClassifier() != null && d.getClassifier().length() > 0) {
            buf.append(':');
            buf.append(d.getClassifier());
        }
        if (d.getVersion() != null && d.getVersion().length() > 0) {
            buf.append(":");
            buf.append(d.getVersion());
        }
        return buf.toString();
    }

    protected boolean isProducedByReactor(Dependency dependency) {
        return this.reactorProjects.stream().anyMatch(reactorProject -> this.compare((MavenProject)reactorProject, dependency));
    }

    private boolean compare(MavenProject project, Dependency dep) {
        if (!StringUtils.equals((CharSequence)project.getGroupId(), (CharSequence)dep.getGroupId())) {
            return false;
        }
        return project.getArtifactId().equals(dep.getArtifactId());
    }

    private boolean compare(Artifact artifact, Dependency dep) {
        if (!StringUtils.equals((CharSequence)artifact.getGroupId(), (CharSequence)dep.getGroupId())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)artifact.getArtifactId(), (CharSequence)dep.getArtifactId())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)artifact.getType(), (CharSequence)dep.getType())) {
            return false;
        }
        return StringUtils.equals((CharSequence)artifact.getClassifier(), (CharSequence)dep.getClassifier());
    }

    protected boolean isIncluded(Artifact artifact) {
        ArtifactFilter scopeFilter;
        ArtifactFilter excludesFilter;
        boolean result = true;
        ArtifactFilter includesFilter = this.getIncludesArtifactFilter();
        if (includesFilter != null) {
            result = includesFilter.include(artifact);
        }
        if ((excludesFilter = this.getExcludesArtifactFilter()) != null) {
            boolean bl = result = result && excludesFilter.include(artifact);
        }
        if ((scopeFilter = this.getScopeArtifactFilter()) != null) {
            result = result && scopeFilter.include(artifact);
        }
        return result;
    }

    protected boolean hasIncludes() {
        return this.includes != null || this.includesList != null;
    }

    private ArtifactFilter getIncludesArtifactFilter() {
        if (this.includesFilter == null && (this.includes != null || this.includesList != null)) {
            ArrayList<String> patterns = new ArrayList<String>();
            if (this.includesList != null) {
                patterns.addAll(this.separatePatterns(this.includesList));
            } else if (this.includes != null) {
                patterns.addAll(Arrays.asList(this.includes));
            }
            this.includesFilter = new PatternIncludesArtifactFilter(patterns);
        }
        return this.includesFilter;
    }

    private ArtifactFilter getExcludesArtifactFilter() {
        if (this.excludesFilter == null && (this.excludes != null || this.excludesList != null)) {
            ArrayList<String> patterns = new ArrayList<String>();
            if (this.excludesList != null) {
                patterns.addAll(this.separatePatterns(this.excludesList));
            } else if (this.excludes != null) {
                patterns.addAll(Arrays.asList(this.excludes));
            }
            this.excludesFilter = new PatternExcludesArtifactFilter(patterns);
        }
        return this.excludesFilter;
    }

    private ArtifactFilter getScopeArtifactFilter() {
        if (this.scope == null) {
            return null;
        }
        return new ScopeArtifactFilter(this.scope);
    }

    protected List<String> separatePatterns(String includeString) {
        if (includeString == null) {
            return Collections.emptyList();
        }
        ArrayList<String> patterns = new ArrayList<String>();
        int indexOf = this.nextCommaIndex(includeString);
        while (indexOf >= 0) {
            patterns.add(includeString.substring(0, indexOf));
            includeString = includeString.substring(indexOf + 1);
            indexOf = this.nextCommaIndex(includeString);
        }
        patterns.add(includeString);
        return patterns;
    }

    private int nextCommaIndex(String includeString) {
        int indexOfComma = includeString.indexOf(44);
        int nextRangeStartDelimiterIndex = this.findFirstChar(includeString, START_RANGE_CHARS);
        if (nextRangeStartDelimiterIndex >= 0 && (indexOfComma < 0 || indexOfComma >= nextRangeStartDelimiterIndex)) {
            int nextStopDelimiterIndex = this.findFirstChar(includeString, END_RANGE_CHARS);
            int tmp = this.nextCommaIndex(includeString.substring(nextStopDelimiterIndex + 1));
            indexOfComma = tmp >= 0 ? nextStopDelimiterIndex + 1 + tmp : -1;
        }
        return indexOfComma;
    }

    private int findFirstChar(String includeString, String chars) {
        char[] delimiters;
        int nextRangeStartDelimiterIndex = -1;
        for (char delimiter : delimiters = chars.toCharArray()) {
            int index = includeString.indexOf(delimiter);
            if (index >= 0 && nextRangeStartDelimiterIndex >= 0) {
                nextRangeStartDelimiterIndex = Math.min(index, nextRangeStartDelimiterIndex);
                continue;
            }
            if (index < 0) continue;
            nextRangeStartDelimiterIndex = index;
        }
        return nextRangeStartDelimiterIndex;
    }

    protected boolean updateDependencyVersion(ModifiedPomXMLEventReader pom, Dependency dep, String newVersion, DependencyChangeRecord.ChangeKind changeKind) throws XMLStreamException, MojoExecutionException {
        boolean updated = false;
        if (this.isProcessingParent() && this.getProject().getParent() != null && DependencyComparator.INSTANCE.compare(dep, DependencyBuilder.newBuilder().withGroupId(this.getProject().getParentArtifact().getGroupId()).withArtifactId(this.getProject().getParentArtifact().getArtifactId()).withVersion(this.getProject().getParentArtifact().getVersion()).build()) == 0 && PomHelper.setProjectParentVersion((ModifiedPomXMLEventReader)pom, (String)newVersion)) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Made parent update from " + dep.getVersion() + " to " + newVersion));
            }
            this.getChangeRecorder().recordChange(DefaultDependencyChangeRecord.builder().withKind(changeKind).withDependency(dep).withNewVersion(newVersion).build());
            updated = true;
        }
        if (PomHelper.setDependencyVersion((ModifiedPomXMLEventReader)pom, (String)dep.getGroupId(), (String)dep.getArtifactId(), (String)dep.getVersion(), (String)newVersion, (Model)this.getProject().getModel())) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Updated " + this.toString(dep) + " to version " + newVersion));
            }
            this.getChangeRecorder().recordChange(DefaultDependencyChangeRecord.builder().withKind(changeKind).withDependency(dep).withNewVersion(newVersion).build());
            updated = true;
        }
        return updated;
    }
}

