/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsReport;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.reporting.ReportRendererFactory;
import org.codehaus.mojo.versions.reporting.model.PluginUpdatesModel;
import org.codehaus.mojo.versions.utils.MiscUtils;
import org.codehaus.mojo.versions.utils.PluginComparator;
import org.codehaus.mojo.versions.xml.PluginUpdatesXmlReportRenderer;
import org.codehaus.plexus.i18n.I18N;

public abstract class AbstractPluginUpdatesReportMojo
extends AbstractVersionsReport<PluginUpdatesModel> {
    private static final PluginComparator PLUGIN_COMPARATOR = PluginComparator.INSTANCE;
    @Parameter(property="pluginUpdatesReportFormats", defaultValue="html")
    private String[] formats = new String[]{"html"};
    @Parameter(property="onlyProjectPlugins", defaultValue="false")
    protected boolean onlyProjectPlugins;
    @Parameter(property="onlyUpgradable", defaultValue="false")
    protected boolean onlyUpgradable;

    public AbstractPluginUpdatesReportMojo(I18N i18n, RepositorySystem repositorySystem, org.eclipse.aether.RepositorySystem aetherRepositorySystem, Map<String, Wagon> wagonMap, ReportRendererFactory rendererFactory) {
        super(i18n, repositorySystem, aetherRepositorySystem, wagonMap, rendererFactory);
    }

    public boolean isExternalReport() {
        return false;
    }

    public boolean canGenerateReport() {
        return this.haveBuildPlugins(this.getProject()) || this.haveBuildPluginManagementPlugins(this.getProject());
    }

    protected boolean haveBuildPluginManagementPlugins(MavenProject project) {
        return project.getBuild() != null && project.getBuild().getPluginManagement() != null && project.getBuild().getPluginManagement().getPlugins() != null && !project.getBuild().getPluginManagement().getPlugins().isEmpty();
    }

    protected boolean haveBuildPlugins(MavenProject project) {
        return project.getBuild() != null && project.getBuild().getPlugins() != null && !project.getBuild().getPlugins().isEmpty();
    }

    @Override
    protected void doGenerateReport(Locale locale, Sink sink) throws MavenReportException {
        Set<Plugin> pluginManagement = this.getPluginManagement();
        Set<Plugin> plugins = this.getPlugins();
        this.handleOnlyProjectPlugins(pluginManagement, plugins);
        try {
            Map pluginUpdates = this.getHelper().lookupPluginsUpdates(plugins, this.getAllowSnapshots().booleanValue());
            Map pluginManagementUpdates = this.getHelper().lookupPluginsUpdates(pluginManagement, this.getAllowSnapshots().booleanValue());
            if (this.onlyUpgradable) {
                pluginUpdates = MiscUtils.filter((Map)pluginUpdates, p -> !p.isEmpty(this.allowSnapshots));
                pluginManagementUpdates = MiscUtils.filter((Map)pluginManagementUpdates, p -> !p.isEmpty(this.allowSnapshots));
            }
            this.renderReport(locale, sink, new PluginUpdatesModel(pluginUpdates, pluginManagementUpdates));
        }
        catch (VersionRetrievalException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private Set<Plugin> getPluginManagement() {
        TreeSet<Plugin> pluginManagementCollector = new TreeSet<Plugin>((Comparator<Plugin>)PLUGIN_COMPARATOR);
        this.populatePluginManagement(pluginManagementCollector);
        return pluginManagementCollector;
    }

    protected abstract void populatePluginManagement(Set<Plugin> var1);

    private Set<Plugin> getPlugins() {
        TreeSet<Plugin> pluginsCollector = new TreeSet<Plugin>((Comparator<Plugin>)PLUGIN_COMPARATOR);
        this.populatePlugins(pluginsCollector);
        return pluginsCollector;
    }

    protected abstract void populatePlugins(Set<Plugin> var1);

    private void renderReport(Locale locale, Sink sink, PluginUpdatesModel model) throws MavenReportException {
        for (String format : this.formats) {
            if ("html".equals(format)) {
                this.rendererFactory.createReportRenderer(this.getOutputName(), sink, locale, model, this.allowSnapshots).render();
                continue;
            }
            if (!"xml".equals(format)) continue;
            Path outputDir = Paths.get(this.getProject().getBuild().getDirectory(), new String[0]);
            if (!Files.exists(outputDir, new LinkOption[0])) {
                try {
                    Files.createDirectories(outputDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new MavenReportException("Could not create the output directory");
                }
            }
            Path outputFile = outputDir.resolve(this.getOutputName() + ".xml");
            new PluginUpdatesXmlReportRenderer(model, outputFile, this.allowSnapshots).render();
        }
    }

    private void handleOnlyProjectPlugins(Set<Plugin> pluginManagement, Set<Plugin> plugins) {
        if (!this.onlyProjectPlugins) {
            plugins.removeIf(plugin -> pluginManagement.stream().anyMatch(pmPlugin -> PLUGIN_COMPARATOR.compare(plugin, pmPlugin) == 0));
        } else {
            pluginManagement.removeIf(pmPlugin -> plugins.stream().noneMatch(plugin -> PLUGIN_COMPARATOR.compare(plugin, pmPlugin) == 0));
        }
    }

    public abstract String getOutputName();
}

