/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.ordering;

import java.math.BigInteger;
import java.util.StringTokenizer;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.codehaus.mojo.versions.ordering.AbstractVersionComparator;
import org.codehaus.mojo.versions.ordering.ComparableVersion;
import org.codehaus.mojo.versions.ordering.VersionComparators;

public class MercuryVersionComparator
extends AbstractVersionComparator {
    private static final BigInteger BIG_INTEGER_ONE = new BigInteger("1");

    public int compare(Object o1, Object o2) {
        return new ComparableVersion(o1.toString()).compareTo(new ComparableVersion(o2.toString()));
    }

    protected int innerGetSegmentCount(ArtifactVersion v) {
        String version = v.toString();
        StringTokenizer tok = new StringTokenizer(version, ".-");
        return tok.countTokens();
    }

    protected ArtifactVersion innerIncrementSegment(ArtifactVersion v, int segment) {
        String token;
        if (segment < 0 || segment > this.getSegmentCount(v)) {
            throw new IllegalArgumentException("Invalid segment");
        }
        String version = v.toString();
        StringBuffer result = new StringBuffer(version.length() + 10);
        StringTokenizer tok = new StringTokenizer(version, ".-");
        int index = 0;
        while (tok.hasMoreTokens() && segment > 0) {
            token = tok.nextToken();
            result.append(token);
            index += token.length();
            if (tok.hasMoreTokens()) {
                result.append(version.substring(index, index + 1));
                ++index;
            }
            --segment;
        }
        if (segment == 0) {
            if (tok.hasMoreTokens()) {
                String newToken;
                token = tok.nextToken();
                try {
                    BigInteger n = new BigInteger(token);
                    newToken = n.add(BIG_INTEGER_ONE).toString();
                }
                catch (NumberFormatException e) {
                    newToken = "alpha".equalsIgnoreCase(token) ? "beta" : ("beta".equalsIgnoreCase(token) ? "milestone" : ("milestone".equalsIgnoreCase(token) ? "rc" : ("rc".equalsIgnoreCase(token) || "cr".equalsIgnoreCase(token) ? "ga" : ("final".equalsIgnoreCase(token) || "ga".equalsIgnoreCase(token) || "".equalsIgnoreCase(token) ? "sp" : VersionComparators.alphaNumIncrement(token)))));
                }
                result.append(newToken);
                index += token.length();
                if (tok.hasMoreTokens()) {
                    result.append(version.substring(index, index + 1));
                    ++index;
                }
            } else {
                result.append("1");
            }
        }
        while (tok.hasMoreTokens()) {
            token = tok.nextToken();
            result.append("0");
            index += token.length();
            if (!tok.hasMoreTokens()) continue;
            result.append(version.substring(index, index + 1));
            ++index;
        }
        return new DefaultArtifactVersion(result.toString());
    }
}

