/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Plugin;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.versions.AbstractVersionsReport;
import org.codehaus.mojo.versions.PluginUpdatesRenderer;
import org.codehaus.mojo.versions.utils.PluginComparator;
import org.codehaus.plexus.util.StringUtils;

public class PluginUpdatesReport
extends AbstractVersionsReport {
    public boolean isExternalReport() {
        return false;
    }

    public boolean canGenerateReport() {
        return this.haveBuildPlugins() || this.haveBuildPluginManagementPlugins();
    }

    private boolean haveBuildPluginManagementPlugins() {
        return this.getProject().getBuild() != null && this.getProject().getBuild().getPluginManagement() != null && this.getProject().getBuild().getPluginManagement().getPlugins() != null && !this.getProject().getBuild().getPluginManagement().getPlugins().isEmpty();
    }

    private boolean haveBuildPlugins() {
        return this.getProject().getBuild() != null && this.getProject().getBuild().getPlugins() != null && !this.getProject().getBuild().getPlugins().isEmpty();
    }

    protected void doGenerateReport(Locale locale, Sink sink) throws MavenReportException {
        TreeSet pluginManagement = new TreeSet(new PluginComparator());
        if (this.haveBuildPluginManagementPlugins()) {
            pluginManagement.addAll(this.getProject().getBuild().getPluginManagement().getPlugins());
        }
        Set plugins = new TreeSet(new PluginComparator());
        if (this.haveBuildPlugins()) {
            plugins.addAll(this.getProject().getBuild().getPlugins());
        }
        plugins.addAll(this.getProject().getDependencies());
        plugins = PluginUpdatesReport.removePluginManagment(plugins, pluginManagement);
        try {
            Map pluginUpdates = this.getHelper().lookupPluginsUpdates(plugins, this.getAllowSnapshots());
            Map pluginManagementUpdates = this.getHelper().lookupPluginsUpdates(pluginManagement, this.getAllowSnapshots());
            PluginUpdatesRenderer renderer = new PluginUpdatesRenderer(sink, this.getI18n(), this.getOutputName(), locale, pluginUpdates, pluginManagementUpdates);
            renderer.render();
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private static Set removePluginManagment(Set plugins, Set pluginManagement) {
        TreeSet<Plugin> result = new TreeSet<Plugin>(new PluginComparator());
        Iterator i = plugins.iterator();
        while (i.hasNext()) {
            Plugin c = (Plugin)i.next();
            boolean matched = false;
            Iterator j = pluginManagement.iterator();
            while (!matched && j.hasNext()) {
                Plugin t = (Plugin)j.next();
                if (!StringUtils.equals((String)t.getGroupId(), (String)c.getGroupId()) || !StringUtils.equals((String)t.getArtifactId(), (String)c.getArtifactId())) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            result.add(c);
        }
        return result;
    }

    public String getOutputName() {
        return "plugin-updates-report";
    }
}

