/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

public class UpdateParentMojo
extends AbstractVersionsUpdaterMojo {
    protected String parentVersion = null;

    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        VersionRange versionRange;
        String currentVersion;
        if (this.getProject().getParent() == null) {
            this.getLog().info((CharSequence)"Project does not have a parent");
            return;
        }
        if (this.reactorProjects.contains(this.getProject().getParent())) {
            this.getLog().info((CharSequence)"Project's parent is part of the reactor");
            return;
        }
        String version = currentVersion = this.getProject().getParent().getVersion();
        if (this.parentVersion != null) {
            version = this.parentVersion;
        }
        try {
            versionRange = VersionRange.createFromVersionSpec((String)version);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Invalid version range specification: " + version, (Exception)((Object)e));
        }
        Artifact artifact = this.artifactFactory.createDependencyArtifact(this.getProject().getParent().getGroupId(), this.getProject().getParent().getArtifactId(), versionRange, "pom", null, null);
        ArtifactVersion artifactVersion = this.findLatestVersion(artifact, versionRange, null, false);
        if (!this.shouldApplyUpdate(artifact, currentVersion, artifactVersion)) {
            return;
        }
        this.getLog().info((CharSequence)("Updating parent from " + currentVersion + " to " + artifactVersion.toString()));
        if (PomHelper.setProjectParentVersion(pom, artifactVersion.toString())) {
            this.getLog().debug((CharSequence)("Made an update from " + currentVersion + " to " + artifactVersion.toString()));
        }
    }
}

