/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.mojo.versions.DisplayDependencyUpdatesReport;

public class DisplayDependencyUpdatesRenderer
extends AbstractMavenReportRenderer {
    private final Map availableVersions;
    private final Comparator comparator;

    public DisplayDependencyUpdatesRenderer(Sink sink, Map availableVersions, Comparator comparator) {
        super((Sink)((org.codehaus.doxia.sink.Sink)sink));
        this.availableVersions = availableVersions;
        this.comparator = comparator;
    }

    public String getTitle() {
        return "Dependency ArtifactVersions";
    }

    protected void renderBody() {
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text("Overview");
        this.sink.sectionTitle1_();
        this.sink.paragraph();
        this.sink.text("This report summarizes newer versions that may be available for your project's various dependencies. ");
        this.sink.text("Incremental updates (typically passive) are noted in green, minor updates (sometimes passive) are noted in yellow, and major updates (rarely passive) are noted in red. ");
        this.sink.text("Dependencies whose available updates could not be reliably determined appear as \"?\", and should be checked manually.");
        this.sink.paragraph_();
        this.sink.table();
        this.renderHeader();
        Iterator it = this.availableVersions.values().iterator();
        while (it.hasNext()) {
            DisplayDependencyUpdatesReport.MultiVersionSummary summary = (DisplayDependencyUpdatesReport.MultiVersionSummary)it.next();
            this.renderArtifact(summary);
        }
        this.renderHeader();
        this.sink.table_();
        this.sink.section1_();
    }

    private void renderHeader() {
        this.sink.tableRow();
        this.sink.tableHeaderCell();
        this.sink.text("Group ID");
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text("Artifact ID");
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text("Version");
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text("Latest Incremental");
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text("Latest Minor");
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text("Latest Major");
        this.sink.tableHeaderCell_();
        this.sink.tableRow_();
    }

    private void renderArtifact(DisplayDependencyUpdatesReport.MultiVersionSummary summary) {
        Artifact artifact = summary.getArtifact();
        this.sink.tableRow();
        this.sink.tableCell();
        this.sink.text(artifact.getGroupId());
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(artifact.getArtifactId());
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(artifact.getVersion());
        this.sink.tableCell_();
        this.renderVersion(summary.getCurrentVersion(), summary.getLatestIncremental(), "lightgreen");
        this.renderVersion(summary.getLatestIncremental(), summary.getLatestMinor(), "yellow");
        this.renderVersion(summary.getLatestMinor(), summary.getLatestMajor(), "red");
        this.sink.tableRow_();
    }

    private void renderVersion(ArtifactVersion currentVersion, ArtifactVersion comparisonVersion, String color) {
        if (currentVersion == null || comparisonVersion == null || comparisonVersion.toString().equals(comparisonVersion.getQualifier())) {
            this.sink.tableCell();
            this.sink.text("?");
            this.sink.tableCell_();
        } else if (this.comparator.compare(currentVersion, comparisonVersion) >= 0) {
            this.sink.tableCell();
            this.sink.text(comparisonVersion.toString());
            this.sink.tableCell_();
        } else {
            this.sink.rawText("<td style=\"background-color: " + color + "\">");
            this.sink.text(comparisonVersion.toString());
            this.sink.rawText("</td>");
        }
    }
}

