/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.util.List;
import java.util.Locale;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Settings;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.DefaultVersionsHelper;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.plexus.i18n.I18N;

public abstract class AbstractVersionsReport
extends AbstractMavenReport {
    private Renderer siteRenderer;
    private I18N i18n;
    private MavenProject project;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver resolver;
    private File outputDirectory;
    private Boolean skip;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected List remoteArtifactRepositories;
    protected List remotePluginRepositories;
    protected ArtifactRepository localRepository;
    private WagonManager wagonManager;
    private Settings settings;
    private String serverId;
    private String rulesUri;
    protected String comparisonMethod;
    private Boolean allowSnapshots;
    private VersionsHelper helper;

    public VersionsHelper getHelper() throws MojoExecutionException {
        if (this.helper == null) {
            this.helper = new DefaultVersionsHelper(this.artifactFactory, this.artifactMetadataSource, this.remoteArtifactRepositories, this.remotePluginRepositories, this.localRepository, this.wagonManager, this.settings, this.serverId, this.rulesUri, this.comparisonMethod, this.getLog());
        }
        return this.helper;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        if (!Boolean.TRUE.equals(this.skip)) {
            this.getLog().info((CharSequence)this.getSink().toString());
            this.doGenerateReport(locale, this.getSink());
        }
    }

    protected abstract void doGenerateReport(Locale var1, Sink var2);

    protected ArtifactVersion findLatestVersion(Artifact artifact, VersionRange versionRange, Boolean allowingSnapshots, boolean usePluginRepositories) throws MojoExecutionException {
        boolean includeSnapshots = Boolean.TRUE.equals(this.allowSnapshots);
        if (Boolean.TRUE.equals(allowingSnapshots)) {
            includeSnapshots = true;
        }
        if (Boolean.FALSE.equals(allowingSnapshots)) {
            includeSnapshots = false;
        }
        ArtifactVersions artifactVersions = this.getHelper().lookupArtifactVersions(artifact, usePluginRepositories);
        return artifactVersions.getLatestVersion(versionRange, includeSnapshots);
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected String getOutputDirectory() {
        if (!this.outputDirectory.isAbsolute()) {
            this.outputDirectory = new File(this.project.getBasedir(), this.outputDirectory.getPath());
        }
        return this.outputDirectory.getAbsolutePath();
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public String getDescription(Locale locale) {
        return this.getText(locale, "report.description");
    }

    public String getName(Locale locale) {
        return this.getText(locale, "report.name");
    }

    public String getText(Locale locale, String key) {
        return this.i18n.getString(this.getOutputName(), locale, key);
    }

    public Boolean getAllowSnapshots() {
        return this.allowSnapshots;
    }

    public String getComparisonMethod() {
        return this.comparisonMethod;
    }

    public ArtifactResolver getResolver() {
        return this.resolver;
    }
}

