/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Stack;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

public class UpdateParentMojo
extends AbstractVersionsUpdaterMojo {
    protected String parentVersion = null;

    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        VersionRange versionRange;
        String currentVersion;
        if (this.getProject().getParent() == null) {
            this.getLog().info((CharSequence)"Project does not have a parent");
            return;
        }
        if (this.reactorProjects.contains(this.getProject().getParent())) {
            this.getLog().info((CharSequence)"Project's parent is part of the reactor");
            return;
        }
        String version = currentVersion = this.getProject().getParent().getVersion();
        if (this.parentVersion != null) {
            version = this.parentVersion;
        }
        try {
            versionRange = VersionRange.createFromVersionSpec((String)version);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Invalid version range specification: " + version, (Exception)((Object)e));
        }
        Artifact artifact = this.artifactFactory.createDependencyArtifact(this.getProject().getParent().getGroupId(), this.getProject().getParent().getArtifactId(), versionRange, "pom", null, null);
        ArtifactVersion artifactVersion = this.findLatestVersion(artifact, versionRange, null);
        if (!this.shouldApplyUpdate(artifact, currentVersion, artifactVersion)) {
            return;
        }
        this.getLog().info((CharSequence)("Updating parent from " + currentVersion + " to " + artifactVersion.toString()));
        Stack<String> stack = new Stack<String>();
        String path = "";
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartElement()) {
                stack.push(path);
                path = path + "/" + event.asStartElement().getName().getLocalPart();
                if ("/project/parent/version".equals(path)) {
                    pom.mark(0);
                }
            }
            if (!event.isEndElement()) continue;
            if ("/project/parent/version".equals(path)) {
                pom.mark(1);
                if (pom.hasMark(0)) {
                    pom.replaceBetween(0, 1, artifactVersion.toString());
                    this.getLog().debug((CharSequence)("Made an update from " + currentVersion + " to " + artifactVersion.toString()));
                    return;
                }
            }
            path = (String)stack.pop();
        }
    }
}

