/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.templating;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.zip.CRC32;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractFilterSourcesMojo
extends AbstractMojo {
    private static final int CHECKSUM_BUFFER = 4096;
    private int copied = 0;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="maven.resources.escapeString")
    protected String escapeString;
    @Parameter
    protected List<String> delimiters;
    @Parameter(defaultValue="true")
    protected boolean useDefaultDelimiters;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="false")
    protected boolean overwrite;
    @Parameter(defaultValue="true")
    protected boolean skipPoms;
    @Component(hint="default")
    protected MavenResourcesFiltering mavenResourcesFiltering;

    protected abstract File getSourceDirectory();

    protected abstract File getOutputDirectory();

    public void execute() throws MojoExecutionException {
        File sourceDirectory = this.getSourceDirectory();
        if (!this.preconditionsFulfilled(sourceDirectory)) {
            return;
        }
        this.copied = 0;
        File temporaryDirectory = this.getTemporaryDirectory(sourceDirectory);
        this.logInfo("Copying files with filtering to temporary directory.", new Object[0]);
        this.logDebug("Temporary directory for filtering is: %s", temporaryDirectory);
        this.filterSourceToTemporaryDir(sourceDirectory, temporaryDirectory);
        this.copyDirectoryStructure(temporaryDirectory, this.getOutputDirectory());
        this.cleanupTemporaryDirectory(temporaryDirectory);
        if (this.isSomethingBeenUpdated()) {
            this.logInfo("Copied %d files to output directory: %s", this.copied, this.getOutputDirectory());
        } else {
            this.logInfo("No files need to be copied to output directory. Up to date: %s", this.getOutputDirectory());
        }
        this.addSourceFolderToProject(this.project);
        this.logInfo("Source directory: %s added.", this.getOutputDirectory());
    }

    protected int countCopiedFiles() {
        return this.copied;
    }

    private void logInfo(String format, Object ... args) {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)String.format(format, args));
        }
    }

    private void logDebug(String format, Object ... args) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format(format, args));
        }
    }

    private boolean isSomethingBeenUpdated() {
        return this.copied > 0;
    }

    private void cleanupTemporaryDirectory(File temporaryDirectory) throws MojoExecutionException {
        try {
            FileUtils.forceDelete((File)temporaryDirectory);
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    private void filterSourceToTemporaryDir(File sourceDirectory, File temporaryDirectory) throws MojoExecutionException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Resource resource = new Resource();
        resource.setFiltering(true);
        this.logDebug("Source absolute path: %s", sourceDirectory.getAbsolutePath());
        resource.setDirectory(sourceDirectory.getAbsolutePath());
        resources.add(resource);
        MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution(resources, temporaryDirectory, this.project, this.encoding, Collections.emptyList(), Collections.emptyList(), this.session);
        mavenResourcesExecution.setInjectProjectBuildFilters(true);
        mavenResourcesExecution.setEscapeString(this.escapeString);
        mavenResourcesExecution.setOverwrite(this.overwrite);
        this.setDelimitersForExecution(mavenResourcesExecution);
        try {
            this.mavenResourcesFiltering.filterResources(mavenResourcesExecution);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void setDelimitersForExecution(MavenResourcesExecution mavenResourcesExecution) {
        if (this.delimiters != null && !this.delimiters.isEmpty()) {
            LinkedHashSet<String> delims = new LinkedHashSet<String>();
            if (this.useDefaultDelimiters) {
                delims.addAll(mavenResourcesExecution.getDelimiters());
            }
            for (String delim : this.delimiters) {
                if (delim == null) {
                    delims.add("${*}");
                    continue;
                }
                delims.add(delim);
            }
            mavenResourcesExecution.setDelimiters(delims);
        }
    }

    private void preconditionsCopyDirectoryStructure(File sourceDirectory, File destinationDirectory, File rootDestinationDirectory) throws IOException {
        if (sourceDirectory == null) {
            throw new IOException("source directory can't be null.");
        }
        if (destinationDirectory == null) {
            throw new IOException("destination directory can't be null.");
        }
        if (sourceDirectory.equals(destinationDirectory)) {
            throw new IOException("source and destination are the same directory.");
        }
        if (!sourceDirectory.exists()) {
            throw new IOException("Source directory doesn't exists (" + sourceDirectory.getAbsolutePath() + ").");
        }
    }

    private void copyDirectoryStructure(File sourceDirectory, File destinationDirectory) throws MojoExecutionException {
        try {
            File target = destinationDirectory;
            if (!target.isAbsolute()) {
                target = this.resolve(this.project.getBasedir(), destinationDirectory.getPath());
            }
            this.copyDirectoryStructureWithIO(sourceDirectory, target, target);
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    private void copyDirectoryStructureWithIO(File sourceDirectory, File destinationDirectory, File rootDestinationDirectory) throws IOException {
        this.preconditionsCopyDirectoryStructure(sourceDirectory, destinationDirectory, rootDestinationDirectory);
        File[] files = sourceDirectory.listFiles();
        if (files == null) {
            return;
        }
        String sourcePath = sourceDirectory.getAbsolutePath();
        for (File file : files) {
            if (file.equals(rootDestinationDirectory)) continue;
            String dest = file.getAbsolutePath();
            dest = dest.substring(sourcePath.length() + 1);
            File destination = new File(destinationDirectory, dest);
            if (file.isFile()) {
                if (!this.isFileDifferent(file, destination = destination.getParentFile())) continue;
                ++this.copied;
                FileUtils.copyFileToDirectory((File)file, (File)destination);
                continue;
            }
            if (file.isDirectory()) {
                if (!destination.exists() && !destination.mkdirs()) {
                    throw new IOException("Could not create destination directory '" + destination.getAbsolutePath() + "'.");
                }
                this.copyDirectoryStructureWithIO(file, destination, rootDestinationDirectory);
                continue;
            }
            throw new IOException("Unknown file type: " + file.getAbsolutePath());
        }
    }

    private File resolve(File file, String ... subfile) {
        StringBuilder path = new StringBuilder();
        path.append(file.getPath());
        for (String fi : subfile) {
            path.append(File.separator);
            path.append(fi);
        }
        return new File(path.toString());
    }

    private boolean isFileDifferent(File file, File directory) throws IOException {
        File targetFile = this.resolve(directory, file.getName()).getAbsoluteFile();
        return !targetFile.canRead() || this.getCrc32OfFile(file) != this.getCrc32OfFile(targetFile);
    }

    private long getCrc32OfFile(File target) throws IOException {
        FileInputStream fis = null;
        try {
            int bytesRead;
            fis = new FileInputStream(target);
            CRC32 crcMaker = new CRC32();
            byte[] buffer = new byte[4096];
            while ((bytesRead = fis.read(buffer)) != -1) {
                crcMaker.update(buffer, 0, bytesRead);
            }
            long l = crcMaker.getValue();
            return l;
        }
        catch (FileNotFoundException ex) {
            throw new IOException(ex.getLocalizedMessage(), ex);
        }
        finally {
            this.close(fis);
        }
    }

    private void close(Closeable is) throws IOException {
        if (is != null) {
            is.close();
        }
    }

    private File getTemporaryDirectory(File sourceDirectory) {
        File basedir = this.project.getBasedir();
        File target = new File(this.project.getBuild().getDirectory());
        StringBuilder label = new StringBuilder("templates-tmp");
        CRC32 crcMaker = new CRC32();
        crcMaker.update(sourceDirectory.getPath().getBytes());
        label.append(crcMaker.getValue());
        String subfile = label.toString();
        return target.isAbsolute() ? this.resolve(target, subfile) : this.resolve(basedir, target.getPath(), subfile);
    }

    private boolean preconditionsFulfilled(File sourceDirectory) {
        if (this.skipPoms && "pom".equals(this.project.getPackaging())) {
            this.logInfo("Skipping POM project type. Change `skipPoms` to false to run anyway.", new Object[0]);
            return false;
        }
        this.logDebug("source=%s target=%s", sourceDirectory, this.getOutputDirectory());
        if (sourceDirectory == null || !sourceDirectory.exists()) {
            this.logInfo("Requested directory '%s' not added since it does not exist.", sourceDirectory);
            return false;
        }
        return true;
    }

    protected abstract void addSourceFolderToProject(MavenProject var1);
}

