/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sonar.bootstrap;

import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.sonar.bootstrap.MavenPlugin;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public final class MavenUtils {
    private static final String MAVEN_COMPILER_PLUGIN = "maven-compiler-plugin";
    public static final String GROUP_ID_APACHE_MAVEN = "org.apache.maven.plugins";
    public static final String GROUP_ID_CODEHAUS_MOJO = "org.codehaus.mojo";

    private MavenUtils() {
    }

    public static String getJavaVersion(MavenProject pom) {
        MavenPlugin compilerPlugin = MavenPlugin.getPlugin(pom, GROUP_ID_APACHE_MAVEN, MAVEN_COMPILER_PLUGIN);
        if (compilerPlugin != null) {
            return compilerPlugin.getParameter("target");
        }
        return null;
    }

    public static String getJavaSourceVersion(MavenProject pom) {
        MavenPlugin compilerPlugin = MavenPlugin.getPlugin(pom, GROUP_ID_APACHE_MAVEN, MAVEN_COMPILER_PLUGIN);
        if (compilerPlugin != null) {
            return compilerPlugin.getParameter("source");
        }
        return null;
    }

    public static String getSourceEncoding(MavenProject pom) {
        return pom.getProperties().getProperty("project.build.sourceEncoding");
    }

    public static String getPluginSetting(MavenProject project, String pluginId, String optionName, String defaultValue) {
        Xpp3Dom dom = MavenUtils.getPluginConfigurationDom(project, pluginId);
        if (dom != null && dom.getChild(optionName) != null) {
            return dom.getChild(optionName).getValue();
        }
        return defaultValue;
    }

    private static Xpp3Dom getPluginConfigurationDom(MavenProject project, String pluginId) {
        Plugin plugin = (Plugin)project.getBuild().getPluginsAsMap().get(pluginId);
        if (plugin != null) {
            return (Xpp3Dom)plugin.getConfiguration();
        }
        return null;
    }
}

