/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.remotesrc;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.remotesrc.AbstractRemoteSourceMojo;
import org.codehaus.mojo.tools.fs.archive.manager.ArchiverManager;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;

public class SourceUnpackMojo
extends AbstractRemoteSourceMojo {
    public static final String TGZ_TYPE = "tar.gz";
    public static final String TGZ_TYPE2 = "tgz";
    public static final String TBZ_TYPE = "tar.Z";
    public static final String TBZ_TYPE2 = "tar.bz2";
    public static final String[] UNPACK_TYPES = new String[]{"tar.gz", "tgz", "tar.Z", "tar.bz2", "tar"};
    private File sourceArchive;
    private boolean skipUnpack;
    private File expandTarget;
    private boolean overwrite;
    private File workDir;
    private ArchiverManager archiverManager;

    protected void doExecute() throws MojoExecutionException {
        if (!this.overwrite && this.workDir.exists()) {
            this.getLog().info((CharSequence)"Skipping unpack step because working directory already exists. Set '-Dsource.unpack.overwrite=true to override.");
            return;
        }
        try {
            File resolvedSourceArchive;
            if (!this.expandTarget.exists()) {
                this.expandTarget.mkdirs();
            }
            if ((resolvedSourceArchive = this.getSourceArchiveFile(this.getProject().getId())) != null) {
                this.sourceArchive = resolvedSourceArchive;
            }
            if (!this.sourceArchive.exists()) {
                throw new MojoExecutionException("Source archive cannot be unpacked; it does not exist! (archive location: " + this.sourceArchive + ")");
            }
            this.getLog().debug((CharSequence)("Unpacking: " + this.sourceArchive));
            this.unpackArchive(this.sourceArchive, this.expandTarget);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to unpack source archive.", (Exception)e);
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Failed to unpack source archive.", (Exception)((Object)e));
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Failed to unpack source archive.", (Exception)((Object)e));
        }
    }

    private void unpackArchive(File archiveFile, File targetDirectory) throws NoSuchArchiverException, ArchiverException, IOException {
        UnArchiver unArchiver = this.archiverManager.getUnArchiver(archiveFile);
        this.getLog().info((CharSequence)("Using UnArchiver: " + unArchiver + " for: " + archiveFile));
        targetDirectory.mkdirs();
        unArchiver.setDestDirectory(targetDirectory);
        unArchiver.setSourceFile(archiveFile);
        unArchiver.extract();
    }

    protected boolean isSkip() {
        return this.skipUnpack;
    }

    protected CharSequence getSkipMessage() {
        return "Skipping source-archive unpack step (per configuration).";
    }
}

