/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.osxappbundle;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.velocity.VelocityComponent;

public class CreateApplicationBundleMojo
extends AbstractMojo {
    private MavenProject project;
    private File buildDirectory;
    private File diskImageFile;
    private File javaApplicationStub;
    private String mainClass;
    private String bundleName;
    private File iconFile;
    private String version;
    private String jvmVersion;
    private File zipFile;
    private List additionalClasspath;
    private VelocityComponent velocity;
    private String dictionaryFile;
    private ZipArchiver zipArchiver;

    public void execute() throws MojoExecutionException {
        this.buildDirectory.mkdirs();
        File contentsDir = new File(this.buildDirectory, "Contents");
        contentsDir.mkdirs();
        File resourcesDir = new File(contentsDir, "Resources");
        resourcesDir.mkdirs();
        File javaDirectory = new File(resourcesDir, "Java");
        javaDirectory.mkdirs();
        File macOSDirectory = new File(contentsDir, "MacOS");
        macOSDirectory.mkdirs();
        File stub = new File(macOSDirectory, "JavaApplicationStub");
        try {
            FileUtils.copyFile((File)this.javaApplicationStub, (File)stub);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not copy file " + this.javaApplicationStub + " to directory " + macOSDirectory, (Exception)e);
        }
        if (this.iconFile != null) {
            try {
                FileUtils.copyFileToDirectory((File)this.iconFile, (File)resourcesDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying file " + this.iconFile + " to " + resourcesDir, (Exception)e);
            }
        }
        List files = this.copyDependencies(javaDirectory);
        File infoPlist = new File(this.buildDirectory, "Contents/Info.plist");
        this.writeInfoPlist(infoPlist, files);
        if (this.isOsX()) {
            Commandline chmod = new Commandline();
            try {
                chmod.setExecutable("chmod");
                chmod.createArgument().setValue("755");
                chmod.createArgument().setValue(stub.getAbsolutePath());
                chmod.execute();
            }
            catch (CommandLineException e) {
                throw new MojoExecutionException("Error executing " + chmod + " ", (Exception)((Object)e));
            }
            Commandline setFile = new Commandline();
            try {
                setFile.setExecutable("/Developer/Tools/SetFile");
                setFile.createArgument().setValue("-a B");
                setFile.createArgument().setValue(this.buildDirectory.getAbsolutePath());
                setFile.execute();
            }
            catch (CommandLineException e) {
                throw new MojoExecutionException("Error executing " + setFile, (Exception)((Object)e));
            }
            Commandline dmg = new Commandline();
            try {
                dmg.setExecutable("hdiutil");
                dmg.createArgument().setValue("create");
                dmg.createArgument().setValue("-srcfolder");
                dmg.createArgument().setValue(this.buildDirectory.getAbsolutePath());
                dmg.createArgument().setValue(this.diskImageFile.getAbsolutePath());
                dmg.execute();
            }
            catch (CommandLineException e) {
                throw new MojoExecutionException("Error creating disk image " + this.diskImageFile, (Exception)((Object)e));
            }
        }
        this.zipArchiver.setDestFile(this.zipFile);
        try {
            this.zipArchiver.addDirectory(this.buildDirectory.getParentFile(), new String[]{this.buildDirectory.getName() + "/**"}, new String[]{"**/JavaApplicationStub"});
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(this.buildDirectory.getParentFile());
            scanner.setIncludes(new String[]{this.buildDirectory.getName() + "/**/JavaApplicationStub"});
            scanner.scan();
            String[] stubs = scanner.getIncludedFiles();
            for (int i = 0; i < stubs.length; ++i) {
                String s = stubs[i];
                this.zipArchiver.addFile(new File(this.buildDirectory.getParentFile(), s), s, 493);
            }
            this.zipArchiver.createArchive();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Could not create zip archive of application bundle in " + this.zipFile, (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException creating zip archive of application bundle in " + this.zipFile, (Exception)e);
        }
    }

    private boolean isOsX() {
        return System.getProperty("mrj.version") != null;
    }

    private List copyDependencies(File javaDirectory) throws MojoExecutionException {
        ArrayList<String> list = new ArrayList<String>();
        File artifactFile = this.project.getArtifact().getFile();
        list.add(artifactFile.getName());
        try {
            FileUtils.copyFileToDirectory((File)artifactFile, (File)javaDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not copy artifact file " + artifactFile + " to " + javaDirectory);
        }
        Set artifacts = this.project.getArtifacts();
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            File file = artifact.getFile();
            this.getLog().debug((CharSequence)("Adding " + file));
            try {
                FileUtils.copyFileToDirectory((File)file, (File)javaDirectory);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying file " + file + " into " + javaDirectory, (Exception)e);
            }
            list.add(file.getName());
        }
        return list;
    }

    private void writeInfoPlist(File infoPlist, List files) throws MojoExecutionException {
        int i;
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("mainClass", (Object)this.mainClass);
        velocityContext.put("bundleName", (Object)this.bundleName);
        velocityContext.put("iconFile", (Object)(this.iconFile == null ? "GenericJavaApp.icns" : this.iconFile.getName()));
        velocityContext.put("version", (Object)this.version);
        velocityContext.put("jvmVersion", (Object)this.jvmVersion);
        StringBuffer jarFilesBuffer = new StringBuffer();
        jarFilesBuffer.append("<array>");
        for (i = 0; i < files.size(); ++i) {
            String name = (String)files.get(i);
            jarFilesBuffer.append("<string>");
            jarFilesBuffer.append("$JAVAROOT/").append(name);
            jarFilesBuffer.append("</string>");
        }
        if (this.additionalClasspath != null) {
            for (i = 0; i < this.additionalClasspath.size(); ++i) {
                String pathElement = (String)this.additionalClasspath.get(i);
                jarFilesBuffer.append("<string>");
                jarFilesBuffer.append(pathElement);
                jarFilesBuffer.append("</string>");
            }
        }
        jarFilesBuffer.append("</array>");
        velocityContext.put("classpath", (Object)jarFilesBuffer.toString());
        try {
            FileWriter writer = new FileWriter(infoPlist);
            this.velocity.getEngine().mergeTemplate(this.dictionaryFile, "utf-8", (Context)velocityContext, (Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not write Info.plist to file " + infoPlist, (Exception)e);
        }
        catch (ParseErrorException e) {
            throw new MojoExecutionException("Error parsing " + this.dictionaryFile, (Exception)((Object)e));
        }
        catch (ResourceNotFoundException e) {
            throw new MojoExecutionException("Could not find resource for template " + this.dictionaryFile, (Exception)((Object)e));
        }
        catch (MethodInvocationException e) {
            throw new MojoExecutionException("MethodInvocationException occured merging Info.plist template " + this.dictionaryFile, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception occured merging Info.plist template " + this.dictionaryFile, e);
        }
    }
}

