/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.freeform.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.freeform.FreeformPluginException;

public class PropertyWriter {
    private ArtifactRepository localRepository;
    private MavenProject mavenProject;
    private File propertyFile;
    private Log log;
    private String mavenpath;

    public PropertyWriter(File propertyFile, Log log, ArtifactRepository localRepository, MavenProject mavenProject, String mavenpath) {
        this.propertyFile = propertyFile;
        this.log = log;
        this.localRepository = localRepository;
        this.mavenProject = mavenProject;
        this.mavenpath = mavenpath;
    }

    public void write() throws FreeformPluginException {
        Properties properties = new Properties();
        properties.put("local.repository", this.localRepository.getBasedir());
        this.log.debug((CharSequence)("using local repository : " + this.localRepository.getBasedir()));
        properties.put("project.directory", this.mavenProject.getBasedir().getAbsolutePath());
        this.log.debug((CharSequence)("using project directory : " + this.mavenProject.getBasedir().getAbsolutePath()));
        String path = this.mavenpath;
        if (path == null) {
            path = System.getProperty("os.name").toLowerCase().startsWith("windows") ? "mvn.bat" : "mvn";
        }
        properties.put("mvn.path", path);
        this.log.debug((CharSequence)("using maven path : " + path));
        try {
            properties.store(new FileOutputStream(this.propertyFile), "The netbeans freeform property file");
        }
        catch (IOException e) {
            this.log.error((CharSequence)"The property file can not be writed.", (Throwable)e);
            throw new FreeformPluginException("The property file can not be writed", e);
        }
    }
}

