/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.nbm.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;

public class ExamineManifest {
    private final Log logger;
    private File jarFile;
    private File manifestFile;
    private boolean netBeansModule;
    private boolean osgiBundle;
    private boolean localized;
    private String specVersion;
    private String implVersion;
    private String module;
    private String locBundle;
    private String classpath;
    private boolean publicPackages;
    private boolean populateDependencies = false;
    private List<String> dependencyTokens = Collections.emptyList();
    private Set<String> osgiImports = Collections.emptySet();
    private Set<String> osgiExports = Collections.emptySet();
    private boolean friendPackages = false;
    private List<String> friends = Collections.emptyList();
    private List<String> packages = Collections.emptyList();
    private List<String> requires = Collections.emptyList();
    private List<String> provides = Collections.emptyList();
    private boolean bundleAutoload = true;

    public ExamineManifest(Log logger) {
        this.logger = logger;
    }

    public void checkFile() throws MojoExecutionException {
        this.resetExamination();
        Manifest mf = null;
        if (this.jarFile != null) {
            JarFile jar = null;
            try {
                jar = new JarFile(this.jarFile);
                mf = jar.getManifest();
            }
            catch (Exception exc) {
                throw new MojoExecutionException("Could not open " + this.jarFile + ": " + exc.getMessage(), exc);
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException io) {
                        throw new MojoExecutionException(io.getMessage(), (Exception)io);
                    }
                }
            }
        }
        if (this.manifestFile != null) {
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(this.manifestFile);
                mf = new Manifest(stream);
            }
            catch (Exception exc) {
                throw new MojoExecutionException(exc.getMessage(), exc);
            }
            finally {
                if (stream != null) {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException io) {
                        throw new MojoExecutionException(io.getMessage(), (Exception)io);
                    }
                }
            }
        }
        if (mf != null) {
            this.processManifest(mf);
        } else {
            File source = this.manifestFile;
            if (source == null) {
                source = this.jarFile;
            }
            if (source == null) {
                this.logger.debug((CharSequence)"No manifest to examine");
            } else {
                this.logger.debug((CharSequence)("Cannot find manifest entries in " + source.getAbsolutePath()));
            }
        }
    }

    private void resetExamination() {
        this.setNetBeansModule(false);
        this.localized = false;
        this.specVersion = null;
        this.implVersion = null;
        this.module = null;
        this.locBundle = null;
        this.publicPackages = false;
        this.classpath = "";
    }

    private void processManifest(Manifest mf) {
        Attributes attrs = mf.getMainAttributes();
        this.module = attrs.getValue("OpenIDE-Module");
        this.setNetBeansModule(this.getModule() != null);
        if (this.isNetBeansModule()) {
            this.locBundle = attrs.getValue("OpenIDE-Module-Localizing-Bundle");
            this.localized = this.locBundle != null;
            this.specVersion = attrs.getValue("OpenIDE-Module-Specification-Version");
            this.implVersion = attrs.getValue("OpenIDE-Module-Implementation-Version");
            String cp = attrs.getValue(Attributes.Name.CLASS_PATH);
            this.classpath = cp == null ? "" : cp;
            String value = attrs.getValue("OpenIDE-Module-Public-Packages");
            String frList = attrs.getValue("OpenIDE-Module-Friends");
            if (value == null || value.trim().equals("-")) {
                this.publicPackages = false;
            } else {
                if (frList != null) {
                    this.publicPackages = false;
                    String[] friendList = StringUtils.stripAll((String[])StringUtils.split((String)frList, (String)","));
                    this.friendPackages = true;
                    this.friends = Arrays.asList(friendList);
                } else {
                    this.publicPackages = true;
                }
                String[] packageList = StringUtils.stripAll((String[])StringUtils.split((String)value, (String)","));
                this.packages = Arrays.asList(packageList);
            }
            if (this.populateDependencies) {
                String deps = attrs.getValue("OpenIDE-Module-Module-Dependencies");
                if (deps != null) {
                    StringTokenizer tokens = new StringTokenizer(deps, ",");
                    ArrayList<String> depList = new ArrayList<String>();
                    while (tokens.hasMoreTokens()) {
                        String tok = tokens.nextToken();
                        int spec = tok.indexOf(62);
                        int impl = tok.indexOf(61);
                        if (spec > 0) {
                            tok = tok.substring(0, spec);
                        } else if (impl > 0) {
                            tok = tok.substring(0, impl);
                        }
                        int slash = tok.indexOf(47);
                        if (slash > 0) {
                            tok = tok.substring(0, slash);
                        }
                        depList.add(tok.trim().intern());
                    }
                    this.dependencyTokens = depList;
                }
                String req = attrs.getValue("OpenIDE-Module-Requires");
                String prov = attrs.getValue("OpenIDE-Module-Provides");
                String needs = attrs.getValue("OpenIDE-Module-Needs");
                if (prov != null) {
                    this.provides = Arrays.asList(StringUtils.stripAll((String[])StringUtils.split((String)prov, (String)",")));
                }
                if (req != null || needs != null) {
                    this.requires = new ArrayList<String>();
                    if (req != null) {
                        this.requires.addAll(Arrays.asList(StringUtils.stripAll((String[])StringUtils.split((String)req, (String)","))));
                    }
                    if (needs != null) {
                        this.requires.addAll(Arrays.asList(StringUtils.stripAll((String[])StringUtils.split((String)needs, (String)","))));
                    }
                }
            }
        } else {
            String bndName = attrs.getValue("Bundle-SymbolicName");
            if (bndName != null) {
                this.osgiBundle = true;
                this.module = bndName.replaceFirst(" *;.+", "").replace('-', '_');
                this.specVersion = attrs.getValue("Bundle-Version");
                String exp = attrs.getValue("Export-Package");
                String autoload = attrs.getValue("Nbm-Maven-Plugin-Autoload");
                if (autoload != null) {
                    this.bundleAutoload = Boolean.parseBoolean(autoload);
                }
                boolean bl = this.publicPackages = exp != null;
                if (this.populateDependencies) {
                    String exps;
                    String imps;
                    String deps = attrs.getValue("Require-Bundle");
                    if (deps != null) {
                        ArrayList<String> depList = new ArrayList<String>();
                        for (String piece : deps.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)")) {
                            depList.add(piece.replaceFirst(";.+", "").trim().intern());
                        }
                        this.dependencyTokens = depList;
                    }
                    if ((imps = attrs.getValue("Import-Package")) != null) {
                        HashSet<String> depList = new HashSet<String>();
                        for (String piece : imps.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)")) {
                            depList.add(piece.replaceFirst(";.+", "").trim().intern());
                        }
                        this.osgiImports = depList;
                    }
                    if ((exps = attrs.getValue("Export-Package")) != null) {
                        HashSet<String> depList = new HashSet<String>();
                        for (String piece : exps.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)")) {
                            depList.add(piece.replaceFirst(";.+", "").trim().intern());
                        }
                        this.osgiExports = depList;
                    }
                }
            } else {
                this.specVersion = attrs.getValue("Specification-Version");
                this.implVersion = attrs.getValue("Implementation-Version");
                this.module = attrs.getValue("Package");
                this.publicPackages = false;
                this.classpath = "";
                if (this.getModule() == null) {
                    this.module = attrs.getValue("Extension-Name");
                }
            }
        }
    }

    public void setJarFile(File jarFileLoc) {
        this.jarFile = jarFileLoc;
    }

    public void setManifestFile(File manifestFileLoc) {
        this.manifestFile = manifestFileLoc;
    }

    public void setArtifactFile(File artifactFileLoc) {
        if (artifactFileLoc.isFile()) {
            this.setJarFile(artifactFileLoc);
        } else if (artifactFileLoc.isDirectory()) {
            File mani = new File(artifactFileLoc, "META-INF/MANIFEST.MF");
            if (mani.isFile()) {
                this.setManifestFile(mani);
            }
        } else {
            throw new IllegalArgumentException(artifactFileLoc.getAbsolutePath());
        }
    }

    public String getClasspath() {
        return this.classpath;
    }

    public boolean isNetBeansModule() {
        return this.netBeansModule;
    }

    public void setNetBeansModule(boolean netBeansModule) {
        this.netBeansModule = netBeansModule;
    }

    public boolean isLocalized() {
        return this.localized;
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public String getImplVersion() {
        return this.implVersion;
    }

    public String getModule() {
        return this.module != null ? this.module.replaceFirst("/\\d+$", "") : this.module;
    }

    public String getModuleWithRelease() {
        return this.module;
    }

    public boolean hasPublicPackages() {
        return this.publicPackages;
    }

    public void setPopulateDependencies(boolean populateDependencies) {
        this.populateDependencies = populateDependencies;
    }

    public List<String> getDependencyTokens() {
        return this.dependencyTokens;
    }

    public boolean hasFriendPackages() {
        return this.friendPackages;
    }

    public List<String> getFriends() {
        return this.friends;
    }

    public List<String> getPackages() {
        return this.packages;
    }

    public boolean isOsgiBundle() {
        return this.osgiBundle;
    }

    public Set<String> getOsgiImports() {
        return this.osgiImports;
    }

    public Set<String> getOsgiExports() {
        return this.osgiExports;
    }

    public List<String> getNetBeansRequiresTokens() {
        return this.requires;
    }

    public List<String> getNetBeansProvidesTokens() {
        return this.provides;
    }

    public boolean isBundleAutoload() {
        return this.bundleAutoload;
    }
}

