/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.native2ascii.mojo;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractNative2AsciiMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    public String encoding;
    @Parameter
    public String[] includes;
    @Parameter
    public String[] excludes;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.checkParameters()) {
            return;
        }
        Iterator<File> files = this.findFiles();
        this.executeTransformation(files);
    }

    protected abstract File getSourceDirectory();

    protected abstract void executeTransformation(Iterator<File> var1) throws MojoExecutionException;

    protected boolean checkParameters() {
        if (!this.getSourceDirectory().exists()) {
            this.getLog().warn((CharSequence)("Source directory does not exist: " + this.getSourceDirectory().getAbsolutePath()));
            return false;
        }
        if (this.includes == null) {
            this.includes = new String[]{"**/*.properties"};
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
        if (StringUtils.isEmpty((CharSequence)this.encoding)) {
            this.encoding = Charset.defaultCharset().displayName();
            this.getLog().warn((CharSequence)("Using platform encoding (" + this.encoding + " actually) to convert resources!"));
        }
        return true;
    }

    private Iterator<File> findFiles() throws MojoExecutionException {
        try {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Includes: " + Arrays.asList(this.includes)));
                this.getLog().debug((CharSequence)("Excludes: " + Arrays.asList(this.excludes)));
            }
            String incl = StringUtils.join((Object[])this.includes, (String)",");
            String excl = StringUtils.join((Object[])this.excludes, (String)",");
            Iterator<File> files = FileUtils.getFiles((File)this.getSourceDirectory(), (String)incl, (String)excl).iterator();
            return files;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to get list of files");
        }
    }
}

