/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.native2ascii;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.CharBuffer;
import org.apache.commons.lang3.text.translate.CodePointTranslator;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.native2ascii.PropertyEscaper;

public final class Native2Ascii {
    private final Log log;
    private final CodePointTranslator escaper;

    public Native2Ascii(Log log) {
        this.log = log;
        this.escaper = new PropertyEscaper();
    }

    public String nativeToAscii(String string) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Converting: " + string));
        }
        if (string == null) {
            return null;
        }
        return this.escaper.translate((CharSequence)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nativeToAscii(File src, File dst, String encoding) throws IOException {
        this.log.info((CharSequence)("Converting: '" + src + "' to: '" + dst + "'"));
        BufferedReader input = null;
        BufferedWriter output = null;
        try {
            int len;
            if (!dst.getParentFile().exists()) {
                dst.getParentFile().mkdirs();
            }
            input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(src), encoding));
            output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dst), "ISO-8859-1"));
            char[] buffer = new char[4096];
            while ((len = input.read(buffer)) != -1) {
                output.write(this.nativeToAscii(CharBuffer.wrap(buffer, 0, len).toString()));
            }
            this.closeQuietly(src, input);
            this.closeQuietly(dst, output);
        }
        catch (Throwable throwable) {
            this.closeQuietly(src, input);
            this.closeQuietly(dst, output);
            throw throwable;
        }
    }

    private void closeQuietly(File file, Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                this.log.warn((CharSequence)("Could not close the file: " + file.getAbsolutePath()));
            }
        }
    }
}

