/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.linker.Linker;
import org.codehaus.mojo.natives.linker.LinkerConfiguration;
import org.codehaus.mojo.natives.manager.LinkerManager;
import org.codehaus.mojo.natives.manager.NoSuchNativeProviderException;
import org.codehaus.mojo.natives.plugin.AbstractNativeMojo;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="link", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class NativeLinkMojo
extends AbstractNativeMojo {
    @Parameter(defaultValue="generic", required=true)
    private String compilerProvider;
    @Parameter
    private String linkerProvider;
    @Parameter
    private String linkerExecutable;
    @Parameter
    private List<String> linkerStartOptions;
    @Parameter
    private List<String> linkerMiddleOptions;
    @Parameter
    private List<String> linkerEndOptions;
    @Parameter
    private List<String> linkingOrderLibs;
    @Parameter(defaultValue="")
    private String linkerSecondaryOutputExtensions;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    protected File linkerOutputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", required=true)
    private String linkerFinalName;
    @Parameter(defaultValue="${project.artifact.artifactHandler.extension}", required=true)
    private String linkerFinalNameExt;
    @Component
    private LinkerManager manager;
    @Component
    private ArtifactFactory artifactFactory;
    @Parameter(defaultValue="${project.build.directory}/lib", required=true)
    private File externalLibDirectory;
    @Parameter
    private String classifier;
    @Parameter(defaultValue="true")
    private boolean attach;
    @Parameter(defaultValue="false")
    private boolean usingLinkerResponseFile;
    @Parameter(defaultValue="false")
    private boolean checkStaleLinkage;
    private LinkerConfiguration config;

    public void execute() throws MojoExecutionException {
        if (StringUtils.isEmpty((String)this.classifier)) {
            this.classifier = null;
        }
        Linker linker = this.getLinker();
        this.config = this.createLinkerConfiguration();
        try {
            List<File> allCompilerOuputFiles = this.getAllCompilersOutputFileList();
            File outputFile = linker.link(this.config, allCompilerOuputFiles);
            allCompilerOuputFiles.clear();
            File file = this.getPluginContext().put("NativeLinkerOutputPath", outputFile);
        }
        catch (IOException | NativeBuildException ioe) {
            throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
        }
        if (this.attach) {
            this.attachPrimaryArtifact();
            this.attachSecondaryArtifacts();
        }
    }

    private LinkerConfiguration createLinkerConfiguration() throws MojoExecutionException {
        LinkerConfiguration config = new LinkerConfiguration();
        config.setWorkingDirectory(this.workingDirectory);
        config.setExecutable(this.linkerExecutable);
        config.setStartOptions(NativeLinkMojo.removeEmptyOptions(this.linkerStartOptions));
        config.setMiddleOptions(NativeLinkMojo.removeEmptyOptions(this.linkerMiddleOptions));
        config.setEndOptions(NativeLinkMojo.removeEmptyOptions(this.linkerEndOptions));
        config.setOutputDirectory(this.linkerOutputDirectory);
        config.setOutputFileName(this.linkerFinalName);
        config.setOutputFileExtension(this.linkerFinalNameExt);
        config.setExternalLibDirectory(this.externalLibDirectory);
        config.setExternalLibFileNames(this.getLibFileNames());
        config.setEnvFactory(this.getEnvFactory());
        config.setUsingLinkerResponseFile(this.usingLinkerResponseFile);
        config.setCheckStaleLinkage(this.checkStaleLinkage);
        return config;
    }

    private Linker getLinker() throws MojoExecutionException {
        Linker linker;
        try {
            if (this.linkerProvider == null) {
                this.linkerProvider = this.compilerProvider;
            }
            linker = this.manager.getLinker(this.linkerProvider);
        }
        catch (NoSuchNativeProviderException pe) {
            throw new MojoExecutionException(pe.getMessage());
        }
        return linker;
    }

    private void attachPrimaryArtifact() {
        Artifact artifact = this.project.getArtifact();
        if (null == this.classifier) {
            artifact.setFile(new File(this.linkerOutputDirectory + "/" + this.project.getBuild().getFinalName() + "." + this.project.getArtifact().getArtifactHandler().getExtension()));
        } else {
            DefaultArtifact clone = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersionRange().cloneOf(), artifact.getScope(), artifact.getType(), this.classifier, artifact.getArtifactHandler(), artifact.isOptional());
            clone.setRelease(artifact.isRelease());
            clone.setResolvedVersion(artifact.getVersion());
            clone.setResolved(artifact.isResolved());
            clone.setFile(artifact.getFile());
            if (artifact.getAvailableVersions() != null) {
                clone.setAvailableVersions(new ArrayList(artifact.getAvailableVersions()));
            }
            clone.setBaseVersion(artifact.getBaseVersion());
            clone.setDependencyFilter(artifact.getDependencyFilter());
            if (artifact.getDependencyTrail() != null) {
                clone.setDependencyTrail(new ArrayList(artifact.getDependencyTrail()));
            }
            clone.setDownloadUrl(artifact.getDownloadUrl());
            clone.setRepository(artifact.getRepository());
            clone.setFile(new File(this.linkerOutputDirectory + "/" + this.project.getBuild().getFinalName() + "." + this.project.getArtifact().getArtifactHandler().getExtension()));
            this.project.setArtifact((Artifact)clone);
        }
    }

    private void attachSecondaryArtifacts() {
        String[] tokens = this.linkerSecondaryOutputExtensions != null ? StringUtils.split((String)this.linkerSecondaryOutputExtensions, (String)",") : new String[]{};
        for (String token : tokens) {
            Artifact artifact = this.artifactFactory.createArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), this.classifier, token.trim());
            artifact.setFile(new File(this.linkerOutputDirectory + "/" + this.project.getBuild().getFinalName() + "." + token.trim()));
            this.project.addAttachedArtifact(artifact);
        }
    }

    private List<String> getLibFileNames() throws MojoExecutionException {
        List<String> libList = new ArrayList<String>();
        Set artifacts = this.project.getArtifacts();
        for (Artifact artifact : artifacts) {
            if ("inczip".equals(artifact.getType())) continue;
            String libFileName = FileUtils.filename((String)this.getDependencyFile(artifact, true).getPath());
            libList.add(libFileName);
        }
        libList = this.reorderLibDependencies(libList);
        return libList;
    }

    private List<String> getDependenciesFileOrderList() throws MojoExecutionException {
        ArrayList<String> list = new ArrayList<String>();
        if (this.linkingOrderLibs != null) {
            for (String element : this.linkingOrderLibs) {
                Artifact artifact = this.lookupDependencyUsingGroupArtifactIdPair(element);
                if (artifact != null) {
                    String libFileName = FileUtils.filename((String)this.getDependencyFile(artifact, false).getPath());
                    list.add(libFileName);
                    continue;
                }
                throw new MojoExecutionException(element + " not found on project dependencies.");
            }
        }
        return list;
    }

    private Artifact lookupDependencyUsingGroupArtifactIdPair(String groupArtifactIdPair) throws MojoExecutionException {
        String[] tokens = StringUtils.split((String)groupArtifactIdPair, (String)":");
        if (tokens.length != 2) {
            throw new MojoExecutionException("Invalid groupId and artifactId pair: " + groupArtifactIdPair);
        }
        Set allDependencyArtifacts = this.project.getDependencyArtifacts();
        for (Artifact artifact : allDependencyArtifacts) {
            if ("inczip".equals(artifact.getType()) || !tokens[0].equals(artifact.getGroupId()) || !tokens[1].equals(artifact.getArtifactId())) continue;
            return artifact;
        }
        return null;
    }

    private List<String> reorderLibDependencies(List<String> libs) throws MojoExecutionException {
        List<String> requestedOrderList = this.getDependenciesFileOrderList();
        if (requestedOrderList.size() != 0) {
            for (String s : requestedOrderList) {
                libs.remove(s);
            }
            requestedOrderList.addAll(libs);
            return requestedOrderList;
        }
        return libs;
    }

    private File getDependencyFile(Artifact artifact, boolean doCopy) throws MojoExecutionException {
        File newLocation = new File(this.externalLibDirectory, artifact.getArtifactId() + "." + artifact.getArtifactHandler().getExtension());
        try {
            if (!(!doCopy || artifact.getFile().isDirectory() || newLocation.exists() && newLocation.lastModified() > artifact.getFile().lastModified())) {
                FileUtils.copyFile((File)artifact.getFile(), (File)newLocation);
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to copy dependency to staging area.  Could not copy " + artifact.getFile() + " to " + newLocation, (Exception)ioe);
        }
        return newLocation;
    }

    protected LinkerConfiguration getLgetLinkerConfiguration() {
        return this.config;
    }
}

