/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.impl.maven;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.catalog.io.xpp3.ArchetypeCatalogXpp3Reader;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.codehaus.mojo.mrm.api.DirectoryEntry;
import org.codehaus.mojo.mrm.api.Entry;
import org.codehaus.mojo.mrm.api.FileEntry;
import org.codehaus.mojo.mrm.api.FileSystem;
import org.codehaus.mojo.mrm.api.maven.ArchetypeCatalogNotFoundException;
import org.codehaus.mojo.mrm.api.maven.Artifact;
import org.codehaus.mojo.mrm.api.maven.ArtifactNotFoundException;
import org.codehaus.mojo.mrm.api.maven.BaseArtifactStore;
import org.codehaus.mojo.mrm.api.maven.MetadataNotFoundException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class FileSystemArtifactStore
extends BaseArtifactStore {
    private final FileSystem backing;

    public FileSystemArtifactStore(FileSystem backing) {
        this.backing = backing;
    }

    public Set<String> getGroupIds(String parentGroupId) {
        DirectoryEntry parentEntry;
        Object object = parentEntry = StringUtils.isEmpty((String)parentGroupId) ? this.backing.getRoot() : this.backing.get(parentGroupId.replace('.', '/'));
        if (!(parentEntry instanceof DirectoryEntry)) {
            return Collections.emptySet();
        }
        DirectoryEntry parentDir = parentEntry;
        Entry[] entries = this.backing.listEntries(parentDir);
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < entries.length; ++i) {
            if (!(entries[i] instanceof DirectoryEntry)) continue;
            result.add(entries[i].getName());
        }
        return result;
    }

    public Set<String> getArtifactIds(String groupId) {
        Entry parentEntry = this.backing.get(groupId.replace('.', '/'));
        if (!(parentEntry instanceof DirectoryEntry)) {
            return Collections.emptySet();
        }
        DirectoryEntry parentDir = (DirectoryEntry)parentEntry;
        Entry[] entries = this.backing.listEntries(parentDir);
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < entries.length; ++i) {
            if (!(entries[i] instanceof DirectoryEntry)) continue;
            result.add(entries[i].getName());
        }
        return result;
    }

    public Set<String> getVersions(String groupId, String artifactId) {
        Entry parentEntry = this.backing.get(groupId.replace('.', '/') + "/" + artifactId);
        if (!(parentEntry instanceof DirectoryEntry)) {
            return Collections.emptySet();
        }
        DirectoryEntry parentDir = (DirectoryEntry)parentEntry;
        Entry[] entries = this.backing.listEntries(parentDir);
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < entries.length; ++i) {
            if (!(entries[i] instanceof DirectoryEntry)) continue;
            result.add(entries[i].getName());
        }
        return result;
    }

    public Set<Artifact> getArtifacts(final String groupId, final String artifactId, final String version) {
        abstract class ArtifactFactory {
            ArtifactFactory() {
            }

            abstract Artifact get(Entry var1);
        }
        ArtifactFactory factory;
        Pattern rule;
        Entry parentEntry = this.backing.get(groupId.replace('.', '/') + "/" + artifactId + "/" + version);
        if (!(parentEntry instanceof DirectoryEntry)) {
            return Collections.emptySet();
        }
        DirectoryEntry parentDir = (DirectoryEntry)parentEntry;
        Entry[] entries = this.backing.listEntries(parentDir);
        if (version.endsWith("-SNAPSHOT")) {
            rule = Pattern.compile("\\Q" + artifactId + "\\E-(?:\\Q" + StringUtils.removeEnd((String)version, (String)"-SNAPSHOT") + "\\E-(SNAPSHOT|(\\d{4})(\\d{2})(\\d{2})\\.(\\d{2})(\\d{2})(\\d{2})-(\\d+)))(?:-([^.]+))?\\.([^/]*)");
            factory = new ArtifactFactory(){
                {
                }

                @Override
                public Artifact get(Entry entry) {
                    Matcher matcher = rule.matcher(entry.getName());
                    if (!matcher.matches()) {
                        return null;
                    }
                    if (matcher.group(1).equals("SNAPSHOT")) {
                        return new Artifact(groupId, artifactId, version, matcher.group(9), matcher.group(10));
                    }
                    try {
                        GregorianCalendar cal = new GregorianCalendar();
                        ((Calendar)cal).setTimeZone(TimeZone.getTimeZone("GMT"));
                        cal.set(1, Integer.parseInt(matcher.group(2)));
                        cal.set(2, Integer.parseInt(matcher.group(3)) - 1);
                        cal.set(5, Integer.parseInt(matcher.group(4)));
                        cal.set(11, Integer.parseInt(matcher.group(5)));
                        cal.set(12, Integer.parseInt(matcher.group(6)));
                        cal.set(13, Integer.parseInt(matcher.group(7)));
                        long timestamp = cal.getTimeInMillis();
                        int buildNumber = Integer.parseInt(matcher.group(8));
                        return new Artifact(groupId, artifactId, version, matcher.group(9), matcher.group(10), timestamp, buildNumber);
                    }
                    catch (NullPointerException e) {
                        return null;
                    }
                }
            };
        } else {
            rule = Pattern.compile("\\Q" + artifactId + "\\E-\\Q" + version + "\\E(?:-([^.]+))?\\.(.+)");
            factory = new ArtifactFactory(){
                {
                }

                @Override
                public Artifact get(Entry entry) {
                    Matcher matcher = rule.matcher(entry.getName());
                    if (!matcher.matches()) {
                        return null;
                    }
                    return new Artifact(groupId, artifactId, version, matcher.group(1), matcher.group(2));
                }
            };
        }
        HashSet<Artifact> result = new HashSet<Artifact>(entries.length);
        for (int i = 0; i < entries.length; ++i) {
            Artifact artifact;
            if (!(entries[i] instanceof FileEntry) || !rule.matcher(entries[i].getName()).matches() || (artifact = factory.get(entries[i])) == null) continue;
            result.add(artifact);
        }
        return result;
    }

    public long getLastModified(Artifact artifact) throws IOException, ArtifactNotFoundException {
        Entry entry = this.backing.get(artifact.getGroupId().replace('.', '/') + "/" + artifact.getArtifactId() + "/" + artifact.getVersion() + "/" + artifact.getName());
        if (!(entry instanceof FileEntry)) {
            throw new ArtifactNotFoundException(artifact);
        }
        return entry.getLastModified();
    }

    public long getSize(Artifact artifact) throws IOException, ArtifactNotFoundException {
        Entry entry = this.backing.get(artifact.getGroupId().replace('.', '/') + "/" + artifact.getArtifactId() + "/" + artifact.getVersion() + "/" + artifact.getName());
        if (!(entry instanceof FileEntry)) {
            throw new ArtifactNotFoundException(artifact);
        }
        return ((FileEntry)entry).getSize();
    }

    public InputStream get(Artifact artifact) throws IOException, ArtifactNotFoundException {
        Entry entry = this.backing.get(artifact.getGroupId().replace('.', '/') + "/" + artifact.getArtifactId() + "/" + artifact.getVersion() + "/" + artifact.getName());
        if (!(entry instanceof FileEntry)) {
            throw new ArtifactNotFoundException(artifact);
        }
        return ((FileEntry)entry).getInputStream();
    }

    public void set(Artifact artifact, InputStream content) throws IOException {
        throw new UnsupportedOperationException("Read-only store");
    }

    public Metadata getMetadata(String path) throws IOException, MetadataNotFoundException {
        Entry entry = this.backing.get(StringUtils.join((Object[])StringUtils.split((String)StringUtils.strip((String)path, (String)"/"), (String)"/"), (String)"/") + "/maven-metadata.xml");
        if (!(entry instanceof FileEntry)) {
            throw new MetadataNotFoundException(path);
        }
        MetadataXpp3Reader reader = new MetadataXpp3Reader();
        InputStream inputStream = null;
        try {
            inputStream = ((FileEntry)entry).getInputStream();
            Metadata metadata = reader.read(inputStream);
            return metadata;
        }
        catch (XmlPullParserException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public long getMetadataLastModified(String path) throws IOException, MetadataNotFoundException {
        Entry entry = this.backing.get(StringUtils.join((Object[])StringUtils.split((String)StringUtils.strip((String)path, (String)"/"), (String)"/"), (String)"/") + "/maven-metadata.xml");
        if (!(entry instanceof FileEntry)) {
            throw new MetadataNotFoundException(path);
        }
        return entry.getLastModified();
    }

    public ArchetypeCatalog getArchetypeCatalog() throws IOException, ArchetypeCatalogNotFoundException {
        Entry entry = this.backing.get("archetype-catalog.xml");
        if (!(entry instanceof FileEntry)) {
            throw new ArchetypeCatalogNotFoundException();
        }
        ArchetypeCatalogXpp3Reader reader = new ArchetypeCatalogXpp3Reader();
        InputStream inputStream = null;
        try {
            inputStream = ((FileEntry)entry).getInputStream();
            ArchetypeCatalog archetypeCatalog = reader.read(inputStream);
            return archetypeCatalog;
        }
        catch (XmlPullParserException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public long getArchetypeCatalogLastModified() throws IOException, ArchetypeCatalogNotFoundException {
        Entry entry = this.backing.get("archetype-catalog.xml");
        if (!(entry instanceof FileEntry)) {
            throw new ArchetypeCatalogNotFoundException();
        }
        return entry.getLastModified();
    }
}

