/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.make;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.codehaus.mojo.make.AbstractMakeExecMojo;
import org.codehaus.mojo.make.Fileset;

public class MakeCleanExecMojo
extends AbstractMakeExecMojo {
    public static final String MAKE_CLEAN_BIN = "clean";
    public static final String MAKE_CLEAN_CONFIG = "distclean";
    private boolean cleanBinaries = true;
    private boolean cleanConfig;
    private File makeWorkDir;
    private List<Fileset> filesets;
    private boolean verbose;
    private FileSetManager fileSetManager;

    public void execute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("In MakeCleanExecMojo.execute:: workDir= " + this.getWorkDir()));
        this.setTarget(null);
        if (this.makeWorkDir != null) {
            this.setWorkDir(this.makeWorkDir);
        }
        ArrayList<String> options = new ArrayList<String>();
        if (this.cleanBinaries) {
            options.add(MAKE_CLEAN_BIN);
        }
        if (this.cleanConfig) {
            options.add(MAKE_CLEAN_CONFIG);
        }
        this.setOptions(options);
        try {
            super.execute();
        }
        catch (MojoExecutionException e) {
            this.getLog().info((CharSequence)("Error cleaning up build generated files. " + e.getMessage()));
        }
        try {
            this.removeAdditionalFilesets();
        }
        catch (MojoExecutionException e) {
            this.getLog().info((CharSequence)e.getMessage());
        }
    }

    private void removeAdditionalFilesets() throws MojoExecutionException {
        if (this.filesets != null && !this.filesets.isEmpty()) {
            this.fileSetManager = new FileSetManager(this.getLog(), this.verbose);
            for (Fileset fileset : this.filesets) {
                try {
                    this.getLog().info((CharSequence)("Deleting " + (Object)((Object)fileset)));
                    this.fileSetManager.delete((FileSet)fileset);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to delete directory: " + fileset.getDirectory() + ". Reason: " + e.getMessage(), (Exception)e);
                }
            }
        }
    }

    public void addFileset(Fileset fileset) {
        if (this.filesets == null) {
            this.filesets = new LinkedList<Fileset>();
        }
        this.filesets.add(fileset);
    }
}

