/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jsimport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsFileArtifactHandler {
    private List<File> files = new ArrayList<File>();
    private File expansionFolder;

    public JsFileArtifactHandler(Artifact artifact, File targetFolder, File workFolder) throws IOException {
        if (artifact.getType().equals("js")) {
            this.files = new ArrayList<File>(1);
            this.files.add(artifact.getFile());
        } else {
            assert (artifact.getType().equals("zip") && artifact.getClassifier().equals("www"));
            File wwwZipFile = artifact.getFile();
            this.files = this.expandWwwZipIntoTargetFolder(artifact, wwwZipFile, targetFolder, workFolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> expandWwwZipIntoTargetFolder(Artifact artifact, File wwwZipFile, File targetFolder, File workFolder) throws IOException {
        ArrayList<File> jsFiles = new ArrayList<File>();
        this.expansionFolder = new File(workFolder, "www-zip" + File.separator + wwwZipFile.getName());
        if (wwwZipFile.lastModified() > this.expansionFolder.lastModified()) {
            String gavPath = artifact.getGroupId().replace('.', File.separatorChar) + File.separator + artifact.getArtifactId() + File.separator + artifact.getVersion();
            File jsExpansionFolder = new File(this.expansionFolder, gavPath);
            FileInputStream fis = new FileInputStream(wwwZipFile);
            try {
                ZipEntry entry;
                ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
                boolean firstEntryProcessed = false;
                int rootFolderPrefixPosn = 0;
                while ((entry = zis.getNextEntry()) != null) {
                    String entryName = entry.getName().substring(rootFolderPrefixPosn);
                    File entryFile = null;
                    if (!entryName.endsWith("js")) {
                        if (!entry.isDirectory()) {
                            entryFile = new File(targetFolder, entryName);
                        } else if (!firstEntryProcessed) {
                            rootFolderPrefixPosn = entryName.length();
                        }
                    } else if (!entryName.endsWith("-min.js")) {
                        entryFile = new File(jsExpansionFolder, entryName);
                        jsFiles.add(entryFile);
                    }
                    if (entryFile != null) {
                        entryFile.getParentFile().mkdirs();
                        FileOutputStream fos = new FileOutputStream(entryFile);
                        FilterOutputStream dest = null;
                        try {
                            int count;
                            int bufferSize = 2048;
                            byte[] data = new byte[2048];
                            dest = new BufferedOutputStream(fos, 2048);
                            while ((count = zis.read(data, 0, 2048)) != -1) {
                                ((BufferedOutputStream)dest).write(data, 0, count);
                            }
                            ((BufferedOutputStream)dest).flush();
                        }
                        finally {
                            dest.close();
                        }
                    }
                    firstEntryProcessed = true;
                }
            }
            finally {
                fis.close();
            }
            this.expansionFolder.setLastModified(wwwZipFile.lastModified());
        } else {
            Collection existingFiles = FileUtils.listFiles((File)this.expansionFolder, (String[])new String[]{"js"}, (boolean)true);
            for (File file : existingFiles) {
                if (file.getName().endsWith("-min.js")) continue;
                jsFiles.add(file);
            }
        }
        return jsFiles;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public File getExpansionFolder() {
        return this.expansionFolder;
    }
}

