/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jdepend;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.codehaus.mojo.jdepend.ReportGenerator;
import org.codehaus.mojo.jdepend.objects.CyclePackage;
import org.codehaus.mojo.jdepend.objects.JDPackage;
import org.codehaus.mojo.jdepend.objects.Stats;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JDependXMLReportParser
extends DefaultHandler {
    protected List<JDPackage> packages;
    protected JDPackage jdpackage;
    protected Stats stats;
    protected StringBuffer buffer = null;
    protected Stack<String> stack;
    protected List<CyclePackage> cycles;
    protected CyclePackage cyclePackage;
    ReportGenerator report;
    private boolean errFlag = false;

    public JDependXMLReportParser(File xmlFile) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        this.stack = new Stack();
        SAXParser saxParser = factory.newSAXParser();
        saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "false");
        saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "false");
        saxParser.parse(xmlFile, (DefaultHandler)this);
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) {
        this.stack.push(qName);
        this.buffer = new StringBuffer();
        switch (qName) {
            case "Packages": {
                this.packages = new ArrayList<JDPackage>();
                break;
            }
            case "Package": {
                if (this.isParentElement("Packages")) {
                    this.jdpackage = new JDPackage();
                    if (attrs == null) break;
                    this.jdpackage.setPackageName(attrs.getValue(0));
                    break;
                }
                if (!this.isParentElement("Cycles")) break;
                this.cyclePackage = new CyclePackage();
                if (attrs == null) break;
                this.cyclePackage.setName(attrs.getValue(0));
                break;
            }
            case "Stats": {
                this.stats = new Stats();
                break;
            }
            case "Cycles": {
                this.cycles = new ArrayList<CyclePackage>();
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) {
        String elementValue = this.buffer != null ? this.buffer.toString().trim() : null;
        switch (qName) {
            case "Package": {
                if (this.isParentElement("Packages")) {
                    if (!this.errFlag) {
                        this.jdpackage.setStats(this.stats);
                        this.packages.add(this.jdpackage);
                    }
                    this.errFlag = false;
                    break;
                }
                if (this.isParentElement("DependsUpon")) {
                    this.jdpackage.addDependsUpon(elementValue);
                    break;
                }
                if (this.isParentElement("UsedBy")) {
                    this.jdpackage.addUsedBy(elementValue);
                    break;
                }
                if (this.isParentElement("Package")) {
                    this.cyclePackage.addPackageList(elementValue);
                    break;
                }
                if (!this.isParentElement("Cycles")) break;
                this.cycles.add(this.cyclePackage);
                break;
            }
            case "TotalClasses": {
                this.stats.setTotalClasses(elementValue);
                break;
            }
            case "ConcreteClasses": {
                if (!this.isParentElement("Stats")) break;
                this.stats.setConcreteClasses(elementValue);
                break;
            }
            case "AbstractClasses": {
                if (!this.isParentElement("Stats")) break;
                this.stats.setAbstractClasses(elementValue);
                break;
            }
            case "Ca": {
                this.stats.setCa(elementValue);
                break;
            }
            case "Ce": {
                this.stats.setCe(elementValue);
                break;
            }
            case "A": {
                this.stats.setA(elementValue);
                break;
            }
            case "I": {
                this.stats.setI(elementValue);
                break;
            }
            case "D": {
                this.stats.setD(elementValue);
                break;
            }
            case "V": {
                this.stats.setV(elementValue);
                break;
            }
            case "Class": {
                if (this.isParentElement("AbstractClasses")) {
                    this.jdpackage.addAbstractClasses(elementValue);
                    break;
                }
                if (!this.isParentElement("ConcreteClasses")) break;
                this.jdpackage.addConcreteClasses(elementValue);
                break;
            }
            case "error": {
                if (!this.isParentElement("Package")) break;
                this.errFlag = true;
            }
        }
        if (this.stack.size() != 0) {
            this.stack.pop();
        }
        this.buffer = null;
    }

    @Override
    public void characters(char[] buff, int offset, int len) {
        if (this.buffer != null) {
            this.buffer.append(buff, offset, len);
        }
    }

    public List<JDPackage> getPackages() {
        return this.packages;
    }

    public Stats getStats() {
        return this.stats;
    }

    private int getParentIndex() {
        return this.stack.size() - 2;
    }

    private boolean isParentElement(String parentElement) {
        return ((String)this.stack.get(this.getParentIndex())).equals(parentElement);
    }
}

