/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jboss.packaging;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.mojo.jboss.packaging.AbstractPackagingMojo;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.util.FileUtils;

public class ParMojo
extends AbstractPackagingMojo {
    private static final String ARTIFACT_TYPE = "jboss-par";
    private ArchiverManager archiverManager;
    private MavenResourcesFiltering mavenResourcesFiltering;
    private List resources;
    private String encoding;
    private MavenSession session;
    private List filters;
    private File deploymentDescriptorFile;
    private File packagingClassesDirectory;
    private File deploymentDescriptorDest;
    private File jbpmDirectory;
    private File jpdlDirectory;

    public String getArtifactType() {
        return ARTIFACT_TYPE;
    }

    public File getDeploymentDescriptor() {
        return this.deploymentDescriptorFile;
    }

    public File getDeploymentDescriptorDest() {
        return this.deploymentDescriptorDest;
    }

    protected void packageResources() throws Exception {
        if (this.resources == null) {
            Resource resource;
            this.resources = new ArrayList();
            if (this.jbpmDirectory.exists()) {
                this.getLog().info((CharSequence)("Configuring jbpm directory: " + this.jbpmDirectory.getPath()));
                resource = new Resource();
                resource.setDirectory(this.jbpmDirectory.getPath());
                resource.addInclude("**/*");
                resource.setFiltering(false);
                this.resources.add(resource);
            }
            if (this.jpdlDirectory.exists()) {
                this.getLog().info((CharSequence)("Configuring jpdl directory: " + this.jpdlDirectory.getPath()));
                resource = new Resource();
                resource.setDirectory(this.jpdlDirectory.getPath());
                resource.addInclude("**/*");
                resource.setFiltering(false);
                this.resources.add(resource);
            }
        }
        MavenResourcesExecution resourcesExec = new MavenResourcesExecution(this.resources, this.getPackagingDirectory(), this.getProject(), this.encoding, this.filters, Collections.EMPTY_LIST, this.session);
        try {
            this.mavenResourcesFiltering.filterResources(resourcesExec);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected void packageClasses() throws Exception {
        FileUtils.copyDirectoryStructure((File)this.getClassesDirectory(), (File)this.packagingClassesDirectory);
    }

    protected void packageLib(Artifact artifact, String name) throws Exception {
        UnArchiver unArchiver = this.archiverManager.getUnArchiver(artifact.getFile());
        unArchiver.setSourceFile(artifact.getFile());
        unArchiver.setDestDirectory(this.packagingClassesDirectory);
        unArchiver.extract();
    }
}

