/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.location;

import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.location.PackageLocation;
import org.codehaus.mojo.jaxb2.shared.Validate;

public class ClassLocation
extends PackageLocation {
    private String className;
    private String classXmlName;

    public ClassLocation(String packageName, String className, String classXmlName) {
        super(packageName);
        Validate.notEmpty(className, "className");
        this.className = className;
        this.classXmlName = classXmlName;
    }

    public String getClassName() {
        return this.classXmlName == null ? this.className : this.classXmlName;
    }

    @Override
    public String getPath() {
        return super.toString() + "." + this.getClassName();
    }

    @Override
    public String getAnnotationRenamedTo() {
        return this.classXmlName;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String toString() {
        String xmlOverriddenFrom = this.classXmlName != null && !this.className.equals(this.classXmlName) ? " (from: " + this.className + ")" : "";
        return super.toString() + "." + this.getClassName() + xmlOverriddenFrom;
    }
}

