/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.javageneration;

import com.sun.tools.xjc.Driver;
import com.sun.tools.xjc.XJCListener;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.codehaus.mojo.jaxb2.AbstractJaxbMojo;
import org.codehaus.mojo.jaxb2.NoSchemasException;
import org.codehaus.mojo.jaxb2.javageneration.SourceContentType;
import org.codehaus.mojo.jaxb2.javageneration.XjcLogAdapter;
import org.codehaus.mojo.jaxb2.shared.FileSystemUtilities;
import org.codehaus.mojo.jaxb2.shared.arguments.ArgumentBuilder;
import org.codehaus.mojo.jaxb2.shared.environment.EnvironmentFacet;
import org.codehaus.mojo.jaxb2.shared.environment.ToolExecutionEnvironment;
import org.codehaus.mojo.jaxb2.shared.environment.classloading.ThreadContextClassLoaderBuilder;
import org.codehaus.mojo.jaxb2.shared.environment.locale.LocaleFacet;
import org.codehaus.mojo.jaxb2.shared.environment.logging.LoggingHandlerEnvironmentFacet;
import org.codehaus.mojo.jaxb2.shared.environment.sysprops.SystemPropertyChangeEnvironmentFacet;
import org.codehaus.mojo.jaxb2.shared.environment.sysprops.SystemPropertySaveEnvironmentFacet;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractJavaGeneratorMojo
extends AbstractJaxbMojo {
    private static final List<String> PROXY_PROPERTY_KEYS = Arrays.asList("http.proxyHost", "http.proxyPort", "https.proxyHost", "https.proxyPort");
    private static final int XJC_COMPLETED_OK = 0;
    @Parameter
    protected File catalog;
    @Deprecated
    @Parameter(defaultValue="true")
    protected boolean generateEpisode;
    @Parameter
    protected String episodeFileName;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter(defaultValue="XmlSchema")
    protected SourceContentType sourceType;
    @Parameter(defaultValue="false")
    protected boolean noPackageLevelAnnotations;
    @Parameter(defaultValue="false")
    protected boolean noGeneratedHeaderComments;
    @Parameter(defaultValue="false")
    protected boolean addGeneratedAnnotation;
    @Parameter(defaultValue="false")
    protected boolean laxSchemaValidation;
    @Parameter(defaultValue="false")
    protected boolean quiet;
    @Parameter(property="xjc.verbose", defaultValue="false")
    protected boolean verbose;
    @Parameter(defaultValue="true")
    protected boolean extension;
    @Parameter(defaultValue="true")
    protected boolean failOnNoSchemas;
    @Parameter(defaultValue="true")
    protected boolean clearOutputDir;
    @Parameter(defaultValue="false")
    protected boolean readOnly;
    protected List<String> plugins;
    @Parameter(property="xjc.arguments")
    protected List<String> arguments;
    @Parameter(defaultValue="false")
    private boolean enableIntrospection;
    @Parameter
    protected String packageName;
    @Parameter
    protected String target;
    @Parameter
    protected String xsdPathWithinArtifact;
    @Parameter(defaultValue="false")
    protected boolean externalEntityProcessing;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isReGenerationRequired() {
        boolean stale;
        File staleFile = this.getStaleFile();
        String debugPrefix = "StaleFile [" + FileSystemUtilities.getCanonicalPath(staleFile) + "]";
        boolean bl = stale = !staleFile.exists();
        if (stale) {
            this.getLog().debug((CharSequence)(debugPrefix + " not found. JAXB (re-)generation required."));
        } else {
            List<URL> sourceXSDs = this.getSources();
            List<File> sourceXJBs = this.getSourceXJBs();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)(debugPrefix + " found. Checking timestamps on source XSD and XJB files to determine if JAXB (re-)generation is required."));
            }
            long staleFileLastModified = staleFile.lastModified();
            for (URL uRL : sourceXSDs) {
                URLConnection sourceXsdConnection;
                try {
                    sourceXsdConnection = uRL.openConnection();
                    sourceXsdConnection.connect();
                }
                catch (Exception e) {
                    stale = true;
                    break;
                }
                try {
                    if (sourceXsdConnection.getLastModified() <= staleFileLastModified) continue;
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)(uRL.toString() + " is newer than the stale flag file."));
                    }
                    stale = true;
                }
                finally {
                    if (!(sourceXsdConnection instanceof HttpURLConnection)) continue;
                    ((HttpURLConnection)sourceXsdConnection).disconnect();
                }
            }
            for (File file : sourceXJBs) {
                if (file.lastModified() <= staleFileLastModified) continue;
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)(FileSystemUtilities.getCanonicalPath(file) + " is newer than the stale flag file."));
                }
                stale = true;
                break;
            }
        }
        return stale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean performExecution() throws MojoExecutionException, MojoFailureException {
        boolean updateStaleFileTimestamp = false;
        try {
            ToolExecutionEnvironment environment = null;
            try {
                boolean reCreateEpisodeFileParentDirectory;
                LocaleFacet localeFacet = this.locale == null ? null : LocaleFacet.createFor(this.locale, this.getLog());
                environment = new ToolExecutionEnvironment(this.getLog(), ThreadContextClassLoaderBuilder.createFor(((Object)((Object)this)).getClass(), this.getLog(), this.getEncoding(false)).addPaths(this.getClasspath()), LoggingHandlerEnvironmentFacet.create(this.getLog(), ((Object)((Object)this)).getClass(), this.getEncoding(false)), localeFacet);
                if (this.extraFacets != null) {
                    for (Object current : this.extraFacets) {
                        environment.add((EnvironmentFacet)current);
                    }
                }
                if (this.externalEntityProcessing) {
                    Object current;
                    List<SystemPropertyChangeEnvironmentFacet> sysPropChanges = SystemPropertyChangeEnvironmentFacet.getBuilder(this.getLog()).addOrChange("enableExternalEntityProcessing", "" + this.externalEntityProcessing).build();
                    current = sysPropChanges.iterator();
                    while (current.hasNext()) {
                        SystemPropertyChangeEnvironmentFacet current2 = (SystemPropertyChangeEnvironmentFacet)current.next();
                        environment.add(current2);
                    }
                }
                for (String key : PROXY_PROPERTY_KEYS) {
                    environment.add(new SystemPropertySaveEnvironmentFacet(key, this.getLog()));
                }
                environment.setup();
                String[] xjcArguments = this.getXjcArguments(environment.getClassPathAsArgument(), this.episodeFileName);
                FileSystemUtilities.createDirectory(this.getOutputDirectory(), this.clearOutputDir);
                boolean bl = reCreateEpisodeFileParentDirectory = this.generateEpisode && this.clearOutputDir;
                if (reCreateEpisodeFileParentDirectory) {
                    this.getEpisodeFile(this.episodeFileName);
                }
                this.logSystemPropertiesAndBasedir();
                if (0 != Driver.run((String[])xjcArguments, (XJCListener)new XjcLogAdapter(this.getLog()))) {
                    StringBuilder errorMsgBuilder = new StringBuilder();
                    errorMsgBuilder.append("\n+=================== [XJC Error]\n");
                    errorMsgBuilder.append("|\n");
                    List<URL> sourceXSDs = this.getSources();
                    for (int i = 0; i < sourceXSDs.size(); ++i) {
                        errorMsgBuilder.append("| " + i + ": ").append(sourceXSDs.get(i).toString()).append("\n");
                    }
                    errorMsgBuilder.append("|\n");
                    errorMsgBuilder.append("+=================== [End XJC Error]\n");
                    throw new MojoExecutionException(errorMsgBuilder.toString());
                }
                this.getBuildContext().refresh(this.getOutputDirectory());
                updateStaleFileTimestamp = true;
            }
            finally {
                if (environment != null) {
                    environment.restore();
                }
            }
            String canonicalPathToOutputDirectory = FileSystemUtilities.getCanonicalPath(this.getOutputDirectory());
            this.addGeneratedSourcesToProjectSourceRoot(canonicalPathToOutputDirectory);
            if (this.xsdPathWithinArtifact != null) {
                String buildOutputDirectory = this.getProject().getBuild().getOutputDirectory();
                File targetXsdDirectory = new File(buildOutputDirectory, this.xsdPathWithinArtifact);
                FileUtils.forceMkdir((File)targetXsdDirectory);
                for (URL current : this.getSources()) {
                    String fileName = null;
                    if ("file".equalsIgnoreCase(current.getProtocol())) {
                        fileName = new File(current.getPath()).getName();
                    } else if ("jar".equalsIgnoreCase(current.getProtocol())) {
                        int bangIndex = current.toString().indexOf("!");
                        if (bangIndex == -1) {
                            throw new MojoExecutionException("Illegal JAR URL [" + current.toString() + "]: lacks a '!'");
                        }
                        String internalPath = current.toString().substring(bangIndex + 1);
                        fileName = new File(internalPath).getName();
                    } else {
                        throw new MojoExecutionException("Could not extract FileName from URL [" + current + "]");
                    }
                    File targetFile = new File(targetXsdDirectory, fileName);
                    if (targetFile.exists()) {
                        this.getLog().warn((CharSequence)("File [" + FileSystemUtilities.getCanonicalPath(targetFile) + "] already exists. Not copying XSD file [" + current.getPath() + "] to it."));
                    }
                    IOUtil.copy((InputStream)current.openStream(), (Writer)new FileWriter(targetFile));
                }
                this.getBuildContext().refresh(targetXsdDirectory);
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (NoSchemasException e) {
            if (this.failOnNoSchemas) {
                throw new MojoExecutionException("", (Exception)e);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        return updateStaleFileTimestamp;
    }

    @Override
    protected abstract List<URL> getSources();

    protected abstract List<File> getSourceXJBs();

    private String[] getXjcArguments(String classPath, String episodeFileNameOrNull) throws MojoExecutionException, NoSchemasException {
        ArgumentBuilder builder = new ArgumentBuilder();
        builder.withFlag(true, this.sourceType.getXjcArgument());
        builder.withFlag(this.noPackageLevelAnnotations, "npa");
        builder.withFlag(this.laxSchemaValidation, "nv");
        builder.withFlag(this.verbose, "verbose");
        builder.withFlag(this.quiet, "quiet");
        builder.withFlag(this.enableIntrospection, "enableIntrospection");
        builder.withFlag(this.extension, "extension");
        builder.withFlag(this.readOnly, "readOnly");
        builder.withFlag(this.noGeneratedHeaderComments, "no-header");
        builder.withFlag(this.addGeneratedAnnotation, "mark-generated");
        builder.withNamedArgument("httpproxy", this.getProxyString(this.settings.getActiveProxy()));
        builder.withNamedArgument("encoding", this.getEncoding(true));
        builder.withNamedArgument("p", this.packageName);
        builder.withNamedArgument("target", this.target);
        builder.withNamedArgument("d", this.getOutputDirectory().getAbsolutePath());
        builder.withNamedArgument("classpath", classPath);
        if (!this.extension && this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Adding 'extension' flag to XJC arguments, to generate an episode file named '" + (this.episodeFileName == null ? "sun-jaxb.episode" : this.episodeFileName) + "'. (XJCs 'episode' argument requires that the 'extension' argument is provided)."));
        }
        builder.withFlag(true, "extension");
        File episodeFile = this.getEpisodeFile(episodeFileNameOrNull);
        builder.withNamedArgument("episode", FileSystemUtilities.getCanonicalPath(episodeFile));
        if (this.catalog != null) {
            builder.withNamedArgument("catalog", FileSystemUtilities.getCanonicalPath(this.catalog));
        }
        if (this.plugins != null) {
            builder.withPrefixedArguments("X", this.plugins);
        }
        if (this.arguments != null) {
            builder.withPreCompiledArguments(this.arguments);
        }
        for (File current : this.getSourceXJBs()) {
            builder.withPreCompiledArguments(Arrays.asList("-b", current.getAbsolutePath()));
        }
        List<URL> sourceXSDs = this.getSources();
        if (sourceXSDs.isEmpty()) {
            this.getLog().warn((CharSequence)"No XSD files found. Please check your plugin configuration.");
            throw new NoSchemasException();
        }
        ArrayList<String> unwrappedSourceXSDs = new ArrayList<String>();
        for (URL current : sourceXSDs) {
            if ("file".equalsIgnoreCase(current.getProtocol())) {
                try {
                    unwrappedSourceXSDs.add(new File(current.toURI()).getPath());
                    continue;
                }
                catch (URISyntaxException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
            unwrappedSourceXSDs.add(current.toString());
        }
        builder.withPreCompiledArguments(unwrappedSourceXSDs);
        return this.logAndReturnToolArguments(builder.build(), "XJC");
    }

    private String getProxyString(Proxy activeProxy) {
        if (activeProxy == null) {
            return null;
        }
        StringBuilder proxyBuilder = new StringBuilder();
        if (activeProxy.getUsername() != null) {
            proxyBuilder.append(activeProxy.getUsername());
            if (activeProxy.getPassword() != null) {
                proxyBuilder.append(":").append(activeProxy.getPassword());
            }
            proxyBuilder.append("@");
        }
        proxyBuilder.append(activeProxy.getHost()).append(":").append(activeProxy.getPort());
        return proxyBuilder.toString();
    }
}

