/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.schemageneration;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.mojo.jaxb2.AbstractJaxbMojo;
import org.codehaus.mojo.jaxb2.schemageneration.AbstractXsdGeneratorMojo;
import org.codehaus.mojo.jaxb2.shared.FileSystemUtilities;
import org.codehaus.mojo.jaxb2.shared.filters.Filter;
import org.codehaus.mojo.jaxb2.shared.filters.Filters;
import org.codehaus.mojo.jaxb2.shared.filters.pattern.PatternFileFilter;

@Mojo(name="testSchemagen", defaultPhase=LifecyclePhase.GENERATE_TEST_RESOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class TestSchemaGenerationMojo
extends AbstractXsdGeneratorMojo {
    public static final String STALE_FILENAME = "testSchemaGenerationStaleFlag";
    public static final List<Filter<File>> STANDARD_TEST_SOURCE_EXCLUDE_FILTERS;
    @Parameter(required=false)
    private List<String> testSources;
    @Parameter(required=false)
    private List<Filter<File>> testSchemaSourceExcludeFilters;
    @Parameter(defaultValue="${project.build.directory}/generated-test-resources/schemagen", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/schemagen-work/test_scope", required=true)
    private File testWorkDirectory;

    @Override
    protected List<URL> getCompiledClassNames() {
        List<Filter<File>> excludeFilters = this.testSchemaSourceExcludeFilters == null ? STANDARD_BYTECODE_EXCLUDE_FILTERS : this.testSchemaSourceExcludeFilters;
        Filters.initialize(this.getLog(), excludeFilters);
        List<String> defaultTestSources = this.getProject().getTestCompileSourceRoots();
        try {
            return FileSystemUtilities.filterFiles(this.getProject().getBasedir(), this.testSources == null ? defaultTestSources : this.testSources, defaultTestSources, this.getLog(), "test-compiled bytecode", excludeFilters);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not resolve test classpath elements.", e);
        }
    }

    @Override
    protected List<String> getClasspath() throws MojoExecutionException {
        List toReturn = null;
        try {
            toReturn = this.getProject().getTestClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Could not acquire compile classpath elements from MavenProject", (Exception)((Object)e));
        }
        return toReturn;
    }

    @Override
    protected List<URL> getSources() {
        List<Filter<File>> excludeFilters = this.testSchemaSourceExcludeFilters == null ? STANDARD_TEST_SOURCE_EXCLUDE_FILTERS : this.testSchemaSourceExcludeFilters;
        Filters.initialize(this.getLog(), excludeFilters);
        return FileSystemUtilities.filterFiles(this.getProject().getBasedir(), this.testSources, this.getProject().getTestCompileSourceRoots(), this.getLog(), "test schema sources", excludeFilters);
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected String getStaleFileName() {
        return STALE_FILENAME;
    }

    @Override
    protected File getWorkDirectory() {
        return this.testWorkDirectory;
    }

    static {
        ArrayList<Filter<File>> testSrcTemp = new ArrayList<Filter<File>>();
        testSrcTemp.addAll(AbstractJaxbMojo.STANDARD_EXCLUDE_FILTERS);
        testSrcTemp.add(new PatternFileFilter(Arrays.asList("\\.xjb", "\\.xsd", "\\.properties"), true));
        STANDARD_TEST_SOURCE_EXCLUDE_FILTERS = Collections.unmodifiableList(testSrcTemp);
    }
}

