/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.shared.version;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.codehaus.mojo.jaxb2.shared.Validate;
import org.codehaus.mojo.jaxb2.shared.version.DependencyInfo;

public final class DependsFileParser {
    private static final String VERSION_LINE_INDICATOR = "/version";
    private static final String TYPE_LINE_INDICATOR = "/type";
    private static final String SCOPE_LINE_INDICATOR = "/scope";
    private static final String GROUP_ARTIFACT_SEPARATOR = "/";
    private static final String KEY_VALUE_SEPARATOR = "=";
    private static final String DEPENDENCIES_PROPERTIES_FILE = "META-INF/maven/dependencies.properties";
    private static final String GENERATION_PREFIX = "# Generated at: ";
    public static final String BUILDTIME_KEY = "buildtime";
    public static final String OWN_ARTIFACTID_KEY = "artifactId";
    public static final String OWN_GROUPID_KEY = "groupId";
    public static final String OWN_VERSION_KEY = "version";

    private DependsFileParser() {
    }

    public static SortedMap<String, String> getVersionMap(String artifactId) {
        Validate.notEmpty(artifactId, "artifactNamePart");
        Exception extractionException = null;
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            ArrayList<URL> manifestURLs = Collections.list(contextClassLoader.getResources(DEPENDENCIES_PROPERTIES_FILE));
            URL matching = null;
            for (URL current : manifestURLs) {
                if (!current.toString().contains(artifactId)) continue;
                matching = current;
            }
            if (matching != null) {
                return DependsFileParser.getVersionMap(matching);
            }
        }
        catch (Exception e) {
            extractionException = e;
        }
        if (extractionException != null) {
            throw new IllegalStateException("Could not read data from manifest.", extractionException);
        }
        throw new IllegalStateException("Found no manifest corresponding to artifact name snippet '" + artifactId + "'.");
    }

    public static SortedMap<String, String> getVersionMap(URL anURL) {
        Validate.notNull(anURL, "anURL");
        TreeMap<String, String> toReturn = new TreeMap<String, String>();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(anURL.openStream()));
            String aLine = null;
            while ((aLine = in.readLine()) != null) {
                String trimmedLine = aLine.trim();
                if (trimmedLine.contains(GENERATION_PREFIX)) {
                    toReturn.put(BUILDTIME_KEY, aLine.substring(GENERATION_PREFIX.length()));
                    continue;
                }
                if ("".equals(trimmedLine) || trimmedLine.startsWith("#") || !trimmedLine.contains(KEY_VALUE_SEPARATOR)) continue;
                StringTokenizer tok = new StringTokenizer(trimmedLine, KEY_VALUE_SEPARATOR, false);
                Validate.isTrue(tok.countTokens() == 2, "Found incorrect dependency.properties line [" + aLine + "]");
                String key = tok.nextToken().trim();
                String value = tok.nextToken().trim();
                toReturn.put(key, value);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not parse dependency properties '" + anURL.toString() + "'", e);
        }
        return toReturn;
    }

    public static SortedMap<String, DependencyInfo> createDependencyInfoMap(SortedMap<String, String> versionMap) {
        String currentKey;
        Validate.notNull(versionMap, "anURL");
        TreeMap<String, DependencyInfo> toReturn = new TreeMap<String, DependencyInfo>();
        for (Map.Entry<String, String> entry : versionMap.entrySet()) {
            currentKey = entry.getKey().trim();
            if (!currentKey.contains(VERSION_LINE_INDICATOR)) continue;
            StringTokenizer tok = new StringTokenizer(currentKey, GROUP_ARTIFACT_SEPARATOR, false);
            Validate.isTrue(tok.countTokens() == 3, "Expected key on the form [groupId]/[artifactId]/version, but got [" + currentKey + "]");
            String groupId = tok.nextToken();
            String artifactId = tok.nextToken();
            DependencyInfo di = new DependencyInfo(groupId, artifactId, entry.getValue());
            toReturn.put(di.getGroupArtifactKey(), di);
        }
        for (Map.Entry<String, String> entry : toReturn.entrySet()) {
            currentKey = entry.getKey();
            DependencyInfo di = (DependencyInfo)((Object)entry.getValue());
            String scope = (String)versionMap.get(currentKey + SCOPE_LINE_INDICATOR);
            String type = (String)versionMap.get(currentKey + TYPE_LINE_INDICATOR);
            if (scope != null) {
                di.setScope(scope);
            }
            if (type == null) continue;
            di.setType(type);
        }
        return toReturn;
    }
}

