/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.flatten;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.flatten.AbstractFlattenMojo;

@Mojo(name="clean", defaultPhase=LifecyclePhase.CLEAN, requiresProject=true, requiresDirectInvocation=false, executionStrategy="once-per-session", threadSafe=true)
public class CleanMojo
extends AbstractFlattenMojo {
    @Parameter(property="flatten.clean.skip", defaultValue="false")
    private boolean skipClean;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.shouldSkip()) {
            this.getLog().info((CharSequence)"Clean skipped.");
            return;
        }
        Path flattenedPomFile = this.getFlattenedPomFile();
        if (Files.isRegularFile(flattenedPomFile, new LinkOption[0])) {
            this.getLog().info((CharSequence)("Deleting " + flattenedPomFile));
            try {
                Files.delete(flattenedPomFile);
            }
            catch (IOException e) {
                throw new MojoFailureException("Could not delete " + flattenedPomFile, (Throwable)e);
            }
        }
    }

    @Override
    protected boolean shouldSkipGoal() {
        return this.skipClean;
    }
}

