/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.flatten;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

class KeepCommentsInPom {
    private Log log;
    private Map<String, Node> commentsPaths;

    static KeepCommentsInPom create(Log aLog, File aOriginalPomFile) throws MojoExecutionException {
        KeepCommentsInPom tempKeepCommentsInPom = new KeepCommentsInPom();
        tempKeepCommentsInPom.setLog(aLog);
        tempKeepCommentsInPom.loadComments(aOriginalPomFile);
        return tempKeepCommentsInPom;
    }

    KeepCommentsInPom() {
    }

    private void loadComments(File anOriginalPomFile) throws MojoExecutionException {
        this.commentsPaths = new HashMap<String, Node>();
        DocumentBuilderFactory tempDBF = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder tempDB = tempDBF.newDocumentBuilder();
            Document tempPom = tempDB.parse(anOriginalPomFile);
            Element tempNode = tempPom.getDocumentElement();
            this.walkOverNodes(tempNode, ".", (node, nodePath) -> this.commentsPaths.put((String)nodePath, (Node)node));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new MojoExecutionException("Cannot load comments from " + anOriginalPomFile, e);
        }
    }

    private void walkOverNodes(Node aNode, String aParentPath, BiConsumer<Node, String> aConsumer) {
        String tempNodeName = aNode.getNodeName();
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("walkOverNodes: aParentPath=" + aParentPath + " tempNodeName=" + tempNodeName));
        }
        String tempNodePath = aParentPath + "\t" + tempNodeName;
        aConsumer.accept(aNode, tempNodePath);
        NodeList tempChilds = aNode.getChildNodes();
        ArrayList<Node> tempCopiedChilds = new ArrayList<Node>();
        HashMap<String, Integer> tempChildWithSameName = new HashMap<String, Integer>();
        for (int i = 0; i < tempChilds.getLength(); ++i) {
            Node tempItem = tempChilds.item(i);
            if (tempItem.getNodeType() == 3 || tempItem.getNodeType() == 8) continue;
            String tempChildNodeName = tempItem.getNodeName();
            Integer tempChildWithSameNameCount = (Integer)tempChildWithSameName.get(tempChildNodeName);
            tempChildWithSameNameCount = tempChildWithSameNameCount == null ? Integer.valueOf(1) : Integer.valueOf(tempChildWithSameNameCount + 1);
            tempChildWithSameName.put(tempChildNodeName, tempChildWithSameNameCount);
            tempCopiedChilds.add(tempItem);
        }
        HashMap<String, Integer> tempChildWithSameNameCounters = new HashMap<String, Integer>();
        for (Node tempCopiedChild : tempCopiedChilds) {
            String tempChildNodeName = tempCopiedChild.getNodeName();
            if ((Integer)tempChildWithSameName.get(tempChildNodeName) > 1) {
                Integer tempChildWithSameNameCounter = (Integer)tempChildWithSameNameCounters.get(tempChildNodeName);
                tempChildWithSameNameCounter = tempChildWithSameNameCounter == null ? Integer.valueOf(1) : Integer.valueOf(tempChildWithSameNameCounter + 1);
                tempChildWithSameNameCounters.put(tempChildNodeName, tempChildWithSameNameCounter);
                this.walkOverNodes(tempCopiedChild, tempNodePath + "\t" + tempChildWithSameNameCounter, aConsumer);
                continue;
            }
            this.walkOverNodes(tempCopiedChild, tempNodePath, aConsumer);
        }
    }

    public String restoreOriginalComments(String anXml, String aModelEncoding) throws MojoExecutionException {
        DocumentBuilderFactory tempDBF = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder tempDB = tempDBF.newDocumentBuilder();
            String tempEncoding = aModelEncoding == null ? "UTF-8" : aModelEncoding;
            Document tempPom = tempDB.parse(new ByteArrayInputStream(anXml.getBytes(tempEncoding)));
            Element tempNode = tempPom.getDocumentElement();
            this.walkOverNodes(tempNode, ".", (newNode, nodePath) -> {
                String tempOriginalNodeName;
                Node tempOriginalNode = this.commentsPaths.get(nodePath);
                if (tempOriginalNode != null && (tempOriginalNodeName = tempOriginalNode.getNodeName()).equals(newNode.getNodeName())) {
                    Node tempPotentialCommentOrText;
                    Node tempRefChild = newNode;
                    for (tempPotentialCommentOrText = tempOriginalNode.getPreviousSibling(); tempPotentialCommentOrText != null && tempPotentialCommentOrText.getNodeType() == 3; tempPotentialCommentOrText = tempPotentialCommentOrText.getPreviousSibling()) {
                    }
                    while (tempPotentialCommentOrText != null && tempPotentialCommentOrText.getNodeType() == 8) {
                        Node tempRefPrevious = tempRefChild.getPreviousSibling();
                        String tempWhitespaceTextBeforeRefNode = null;
                        if (tempRefPrevious != null && tempRefPrevious.getNodeType() == 3) {
                            tempWhitespaceTextBeforeRefNode = tempRefPrevious.getNodeValue();
                        }
                        Comment tempNewComment = tempPom.createComment(tempPotentialCommentOrText.getNodeValue());
                        tempRefChild.getParentNode().insertBefore(tempNewComment, tempRefChild);
                        if (tempWhitespaceTextBeforeRefNode != null) {
                            tempRefChild.getParentNode().insertBefore(tempPom.createTextNode(tempWhitespaceTextBeforeRefNode), tempRefChild);
                        }
                        tempRefChild = tempNewComment;
                        for (tempPotentialCommentOrText = tempPotentialCommentOrText.getPreviousSibling(); tempPotentialCommentOrText != null && tempPotentialCommentOrText.getNodeType() == 3; tempPotentialCommentOrText = tempPotentialCommentOrText.getPreviousSibling()) {
                        }
                    }
                }
            });
            return this.writeDocumentToString(tempPom);
        }
        catch (IOException | ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | ParserConfigurationException | SAXException e) {
            throw new MojoExecutionException("Cannot add  comments", e);
        }
    }

    private String writeDocumentToString(Document aPom) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        LSOutput output = impl.createLSOutput();
        output.setEncoding("UTF-8");
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        output.setByteStream(outStream);
        LSSerializer writer = impl.createLSSerializer();
        writer.write(aPom, output);
        return outStream.toString();
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log aLog) {
        this.log = aLog;
    }
}

