/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.findbugs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:findbugs-maven-plugin:2.4.0", 0);
        this.append(sb, "", 0);
        this.append(sb, "FindBugs Maven Plugin", 0);
        this.append(sb, "This Plug-In generates reports based on the FindBugs Library", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 4 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "check".equals(this.goal)) {
            this.append(sb, "findbugs:check", 0);
            this.append(sb, "Fail the build if there were any FindBugs violations in the source code. An XML report is put out by default in the target directory with the errors. To see more documentation about FindBugs' options, please see the FindBugs Manual..", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classFilesDirectory (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "Directory containing the class files for FindBugs to analyze.", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug (Default: false)", 2);
                this.append(sb, "turn on Findbugs debugging", 3);
                this.append(sb, "", 0);
                this.append(sb, "effort (Default: Default)", 2);
                this.append(sb, "Effort of the bug finders. Valid values are Min, Default and Max.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeFilterFile", 2);
                this.append(sb, "File name of the exclude filter. Bugs matching the filters are not reported.\n\nPotential values are a filesystem path, a URL, or a classpath resource.\n\nThis parameter is resolved as resource, URL, then file. If successfully resolved, the contents of the configuration is copied into the ${project.build.directory} directory before being passed to Findbugs as a filter file.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "Fail the build on an error.", 3);
                this.append(sb, "", 0);
                this.append(sb, "findbugsXmlOutput (Default: false)", 2);
                this.append(sb, "This has been deprecated and is on by default.", 3);
                this.append(sb, "", 0);
                this.append(sb, "findbugsXmlOutputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "Specifies the directory where the findbugs native xml output will be generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fork (Default: true)", 2);
                this.append(sb, "Fork a VM for FindBugs analysis. This will allow you to set timeouts and heap size", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeFilterFile", 2);
                this.append(sb, "File name of the include filter. Only bugs in matching the filters are reported.\n\nPotential values are a filesystem path, a URL, or a classpath resource.\n\nThis parameter is resolved as resource, URL, then file. If successfully resolved, the contents of the configuration is copied into the ${project.build.directory} directory before being passed to Findbugs as a filter file.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeTests (Default: false)", 2);
                this.append(sb, "Run Findbugs on the tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxHeap (Default: 512)", 2);
                this.append(sb, "Maximum Java heap size in megabytes (default=512). This only works if the fork parameter is set true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "nested (Default: false)", 2);
                this.append(sb, "This option enables or disables scanning of nested jar and zip files found in the list of files and directories to be analyzed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "omitVisitors", 2);
                this.append(sb, "The visitor list to omit. This is a comma-delimited list.", 3);
                this.append(sb, "", 0);
                this.append(sb, "onlyAnalyze", 2);
                this.append(sb, "Restrict analysis to the given comma-separated list of classes and packages.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2);
                this.append(sb, "Location where generated html will be created.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputEncoding (Default: ${project.reporting.outputEncoding})", 2);
                this.append(sb, "The file encoding to use when creating the HTML reports. If the property project.reporting.outputEncoding is not set, the platform default encoding is used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginList", 2);
                this.append(sb, "The plugin list to include in the report. This is a comma-delimited list.\n\nPotential values are a filesystem path, a URL, or a classpath resource.\n\nThis parameter is resolved as resource, URL, then file. If successfully resolved, the contents of the configuration is copied into the ${project.build.directory} directory before being passed to Findbugs as a plugin file.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "relaxed (Default: false)", 2);
                this.append(sb, "Relaxed reporting mode. For many detectors, this option suppresses the heuristics used to avoid reporting false positives.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip entire check.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceEncoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The file encoding to use when reading the source files. If the property project.build.sourceEncoding is not set, the platform default encoding is used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testClassFilesDirectory (Default: ${project.build.testOutputDirectory})", 2);
                this.append(sb, "Directory containing the test class files for FindBugs to analyze.", 3);
                this.append(sb, "", 0);
                this.append(sb, "threshold (Default: Default)", 2);
                this.append(sb, "Threshold of minimum bug severity to report. Valid values are High, Default, Low, Ignore, and Exp (for experimental).", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: 600000)", 2);
                this.append(sb, "Specifies the amount of time, in milliseconds, that FindBugs may run before it is assumed to be hung and is terminated. The default is 600,000 milliseconds, which is ten minutes. This only works if the fork parameter is set true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "trace (Default: false)", 2);
                this.append(sb, "Prints a trace of detectors run and classes analyzed to standard output. Useful for troubleshooting unexpected analysis failures.", 3);
                this.append(sb, "", 0);
                this.append(sb, "visitors", 2);
                this.append(sb, "The visitor list to run. This is a comma-delimited list.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xmlOutput (Default: false)", 2);
                this.append(sb, "Turn on and off xml output of the Findbugs report.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xmlOutputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "Specifies the directory where the xml output will be generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xrefLocation (Default: ${project.reporting.outputDirectory}/xref)", 2);
                this.append(sb, "Location of the Xrefs to link to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xrefTestLocation (Default: ${project.reporting.outputDirectory}/xref-test)", 2);
                this.append(sb, "Location of the Test Xrefs to link to.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "findbugs".equals(this.goal)) {
            this.append(sb, "findbugs:findbugs", 0);
            this.append(sb, "Generates a FindBugs Report when the site plugin is run. The HTML report is generated for site commands only.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classFilesDirectory (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "Directory containing the class files for FindBugs to analyze.", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug (Default: false)", 2);
                this.append(sb, "turn on Findbugs debugging", 3);
                this.append(sb, "", 0);
                this.append(sb, "effort (Default: Default)", 2);
                this.append(sb, "Effort of the bug finders. Valid values are Min, Default and Max.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeFilterFile", 2);
                this.append(sb, "File name of the exclude filter. Bugs matching the filters are not reported.\n\nPotential values are a filesystem path, a URL, or a classpath resource.\n\nThis parameter is resolved as resource, URL, then file. If successfully resolved, the contents of the configuration is copied into the ${project.build.directory} directory before being passed to Findbugs as a filter file.\nThis is a comma-delimited list.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "Fail the build on an error.", 3);
                this.append(sb, "", 0);
                this.append(sb, "findbugsXmlOutput (Default: false)", 2);
                this.append(sb, "This has been deprecated and is on by default.", 3);
                this.append(sb, "", 0);
                this.append(sb, "findbugsXmlOutputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "Specifies the directory where the findbugs native xml output will be generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fork (Default: true)", 2);
                this.append(sb, "Fork a VM for FindBugs analysis. This will allow you to set timeouts and heap size", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeFilterFile", 2);
                this.append(sb, "File name of the include filter. Only bugs in matching the filters are reported.\n\nPotential values are a filesystem path, a URL, or a classpath resource.\n\nThis parameter is resolved as resource, URL, then file. If successfully resolved, the contents of the configuration is copied into the ${project.build.directory} directory before being passed to Findbugs as a filter file.\nThis is a comma-delimited list.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeTests (Default: false)", 2);
                this.append(sb, "Run Findbugs on the tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxHeap (Default: 512)", 2);
                this.append(sb, "Maximum Java heap size in megabytes (default=512). This only works if the fork parameter is set true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "nested (Default: false)", 2);
                this.append(sb, "This option enables or disables scanning of nested jar and zip files found in the list of files and directories to be analyzed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "omitVisitors", 2);
                this.append(sb, "The visitor list to omit. This is a comma-delimited list.", 3);
                this.append(sb, "", 0);
                this.append(sb, "onlyAnalyze", 2);
                this.append(sb, "Restrict analysis to the given comma-separated list of classes and packages.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2);
                this.append(sb, "Location where generated html will be created.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputEncoding (Default: ${project.reporting.outputEncoding})", 2);
                this.append(sb, "The file encoding to use when creating the HTML reports. If the property project.reporting.outputEncoding is not set, the platform default encoding is used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginList", 2);
                this.append(sb, "The plugin list to include in the report. This is a comma-delimited list.\n\nPotential values are a filesystem path, a URL, or a classpath resource.\n\nThis parameter is resolved as resource, URL, then file. If successfully resolved, the contents of the configuration is copied into the ${project.build.directory} directory before being passed to Findbugs as a plugin file.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "relaxed (Default: false)", 2);
                this.append(sb, "Relaxed reporting mode. For many detectors, this option suppresses the heuristics used to avoid reporting false positives.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip entire check.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceEncoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The file encoding to use when reading the source files. If the property project.build.sourceEncoding is not set, the platform default encoding is used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testClassFilesDirectory (Default: ${project.build.testOutputDirectory})", 2);
                this.append(sb, "Directory containing the test class files for FindBugs to analyze.", 3);
                this.append(sb, "", 0);
                this.append(sb, "threshold (Default: Default)", 2);
                this.append(sb, "Threshold of minimum bug severity to report. Valid values are High, Default, Low, Ignore, and Exp (for experimental).", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: 600000)", 2);
                this.append(sb, "Specifies the amount of time, in milliseconds, that FindBugs may run before it is assumed to be hung and is terminated. The default is 600,000 milliseconds, which is ten minutes. This only works if the fork parameter is set true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "trace (Default: false)", 2);
                this.append(sb, "Prints a trace of detectors run and classes analyzed to standard output. Useful for troubleshooting unexpected analysis failures.", 3);
                this.append(sb, "", 0);
                this.append(sb, "visitors", 2);
                this.append(sb, "The visitor list to run. This is a comma-delimited list.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xmlOutput (Default: false)", 2);
                this.append(sb, "Turn on and off xml output of the Findbugs report.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xmlOutputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "Specifies the directory where the xml output will be generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xrefLocation (Default: ${project.reporting.outputDirectory}/xref)", 2);
                this.append(sb, "Location of the Xrefs to link to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xrefTestLocation (Default: ${project.reporting.outputDirectory}/xref-test)", 2);
                this.append(sb, "Location of the Test Xrefs to link to.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "gui".equals(this.goal)) {
            this.append(sb, "findbugs:gui", 0);
            this.append(sb, "Launch the Findbugs GUI. It will use all the parameters in the POM fle.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classFilesDirectory (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "Directory containing the class files for FindBugs to analyze.", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug (Default: false)", 2);
                this.append(sb, "turn on Findbugs debugging", 3);
                this.append(sb, "", 0);
                this.append(sb, "effort (Default: Default)", 2);
                this.append(sb, "Effort of the bug finders. Valid values are Min, Default and Max.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The file encoding to use when reading the source files. If the property project.build.sourceEncoding is not set, the platform default encoding is used. Note: This parameter always overrides the property charset from Checkstyle's TreeWalker module.", 3);
                this.append(sb, "", 0);
                this.append(sb, "findbugsXmlOutputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "Specifies the directory where the findbugs native xml output will be generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxHeap (Default: 512)", 2);
                this.append(sb, "Maximum Java heap size in megabytes (default=512).", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginList", 2);
                this.append(sb, "The plugin list to include in the report. This is a comma-delimited list.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "findbugs:help", 0);
            this.append(sb, "Display help information on findbugs-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0findbugs:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

