/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exec;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.IncludesArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.exec.AbstractExecMojo;
import org.codehaus.mojo.exec.Classpath;
import org.codehaus.mojo.exec.StreamLog;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ExecMojo
extends AbstractExecMojo {
    private boolean skip;
    private String executable;
    private File workingDirectory;
    private File outputFile;
    private List arguments;
    private File basedir;
    private Map environmentVariables = new HashMap();
    public static final String CLASSPATH_TOKEN = "%classpath";

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping execute as per configuraion");
            return;
        }
        if (this.basedir == null) {
            throw new IllegalStateException("basedir is null. Should not be possible.");
        }
        String argsProp = this.getSystemProperty("exec.args");
        ArrayList<String> commandArguments = new ArrayList<String>();
        if (this.hasCommandlineArgs()) {
            String[] args = this.parseCommandlineArgs();
            for (int i = 0; i < args.length; ++i) {
                if (CLASSPATH_TOKEN.equals(args[i])) {
                    commandArguments.add(this.computeClasspath(null));
                    continue;
                }
                commandArguments.add(args[i]);
            }
        } else if (!ExecMojo.isEmpty(argsProp)) {
            this.getLog().debug((CharSequence)("got arguments from system properties: " + argsProp));
            StringTokenizer strtok = new StringTokenizer(argsProp, " ");
            while (strtok.hasMoreTokens()) {
                commandArguments.add(strtok.nextToken());
            }
        } else if (this.arguments != null) {
            for (int i = 0; i < this.arguments.size(); ++i) {
                String arg;
                Object argument = this.arguments.get(i);
                if (argument == null) {
                    throw new MojoExecutionException("Misconfigured argument, value is null. Set the argument to an empty value if this is the required behaviour.");
                }
                if (argument instanceof Classpath) {
                    Classpath specifiedClasspath = (Classpath)argument;
                    arg = this.computeClasspath(specifiedClasspath);
                } else {
                    arg = argument.toString();
                }
                commandArguments.add(arg);
            }
        }
        Commandline commandLine = new Commandline();
        commandLine.setExecutable(this.getExecutablePath());
        String[] args = new String[commandArguments.size()];
        for (int i = 0; i < commandArguments.size(); ++i) {
            args[i] = (String)commandArguments.get(i);
        }
        commandLine.addArguments(args);
        if (this.workingDirectory == null) {
            this.workingDirectory = this.basedir;
        }
        if (!this.workingDirectory.exists()) {
            this.getLog().debug((CharSequence)("Making working directory '" + this.workingDirectory.getAbsolutePath() + "'."));
            if (!this.workingDirectory.mkdirs()) {
                throw new MojoExecutionException("Could not make working directory: '" + this.workingDirectory.getAbsolutePath() + "'");
            }
        }
        commandLine.setWorkingDirectory(this.workingDirectory.getAbsolutePath());
        if (this.environmentVariables != null) {
            Iterator iter = this.environmentVariables.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = (String)this.environmentVariables.get(key);
                commandLine.addEnvironment(key, value);
            }
        }
        final Log outputLog = this.getExecOutputLog();
        StreamConsumer stdout = new StreamConsumer(){

            public void consumeLine(String line) {
                outputLog.info((CharSequence)line);
            }
        };
        StreamConsumer stderr = new StreamConsumer(){

            public void consumeLine(String line) {
                outputLog.info((CharSequence)line);
            }
        };
        try {
            int result = this.executeCommandLine(commandLine, stdout, stderr);
            if (result != 0) {
                throw new MojoExecutionException("Result of " + commandLine + " execution is: '" + result + "'.");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Command execution failed.", (Exception)((Object)e));
        }
        this.registerSourceRoots();
    }

    private Log getExecOutputLog() {
        Log log = this.getLog();
        if (this.outputFile != null) {
            try {
                if (!this.outputFile.getParentFile().exists() && !this.outputFile.getParentFile().mkdirs()) {
                    this.getLog().warn((CharSequence)("Could not create non existing parent directories for log file: " + this.outputFile));
                }
                PrintStream stream = new PrintStream(new FileOutputStream(this.outputFile));
                log = new StreamLog(stream);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Could not open " + this.outputFile + ". Using default log"), (Throwable)e);
            }
        }
        return log;
    }

    private String computeClasspath(Classpath specifiedClasspath) {
        List artifacts = new ArrayList();
        ArrayList theClasspathFiles = new ArrayList();
        this.collectProjectArtifactsAndClasspath(artifacts, theClasspathFiles);
        if (specifiedClasspath != null && specifiedClasspath.getDependencies() != null) {
            artifacts = this.filterArtifacts(artifacts, specifiedClasspath.getDependencies());
        }
        StringBuffer theClasspath = new StringBuffer();
        Iterator it = theClasspathFiles.iterator();
        while (it.hasNext()) {
            File f = (File)it.next();
            ExecMojo.addToClasspath(theClasspath, f.getAbsolutePath());
        }
        it = artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            this.getLog().debug((CharSequence)("dealing with " + artifact));
            ExecMojo.addToClasspath(theClasspath, artifact.getFile().getAbsolutePath());
        }
        return theClasspath.toString();
    }

    private static void addToClasspath(StringBuffer theClasspath, String toAdd) {
        if (theClasspath.length() > 0) {
            theClasspath.append(File.pathSeparator);
        }
        theClasspath.append(toAdd);
    }

    private List filterArtifacts(List artifacts, Collection dependencies) {
        AndArtifactFilter filter = new AndArtifactFilter();
        filter.add((ArtifactFilter)new IncludesArtifactFilter(new ArrayList(dependencies)));
        ArrayList<Artifact> filteredArtifacts = new ArrayList<Artifact>();
        Iterator it = artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            if (!filter.include(artifact)) continue;
            this.getLog().debug((CharSequence)("filtering in " + artifact));
            filteredArtifacts.add(artifact);
        }
        return filteredArtifacts;
    }

    String getExecutablePath() {
        File execFile = new File(this.executable);
        if (execFile.exists()) {
            return execFile.getAbsolutePath();
        }
        this.getLog().debug((CharSequence)("executable " + this.executable + " not found in place, assuming it is in the PATH."));
        return this.executable;
    }

    private static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    protected int executeCommandLine(Commandline commandLine, StreamConsumer stream1, StreamConsumer stream2) throws CommandLineException {
        return CommandLineUtils.executeCommandLine((Commandline)commandLine, (StreamConsumer)stream1, (StreamConsumer)stream2);
    }

    void setExecutable(String executable) {
        this.executable = executable;
    }

    String getExecutable() {
        return this.executable;
    }

    void setWorkingDirectory(String workingDir) {
        this.setWorkingDirectory(new File(workingDir));
    }

    void setWorkingDirectory(File workingDir) {
        this.workingDirectory = workingDir;
    }

    void setArguments(List arguments) {
        this.arguments = arguments;
    }

    void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    void setProject(MavenProject project) {
        this.project = project;
    }

    protected String getSystemProperty(String key) {
        return System.getProperty(key);
    }
}

