/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exec;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.IncludesArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.exec.AbstractExecMojo;
import org.codehaus.mojo.exec.Classpath;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ExecMojo
extends AbstractExecMojo {
    private boolean skip;
    private String executable;
    private File workingDirectory;
    private List arguments;
    private File basedir;
    public static final String CLASSPATH_TOKEN = "%classpath";

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping execute as per configuraion");
            return;
        }
        if (this.basedir == null) {
            throw new IllegalStateException("basedir is null. Should not be possible.");
        }
        String argsProp = this.getSystemProperty("exec.args");
        ArrayList<String> commandArguments = new ArrayList<String>();
        if (this.hasCommandlineArgs()) {
            String[] args = this.parseCommandlineArgs();
            for (int i = 0; i < args.length; ++i) {
                if (CLASSPATH_TOKEN.equals(args[i])) {
                    Set artifacts = this.project.getArtifacts();
                    commandArguments.add(this.computeClasspath(artifacts));
                    continue;
                }
                commandArguments.add(args[i]);
            }
        } else if (!ExecMojo.isEmpty(argsProp)) {
            this.getLog().debug((CharSequence)("got arguments from system properties: " + argsProp));
            StringTokenizer strtok = new StringTokenizer(argsProp, " ");
            while (strtok.hasMoreTokens()) {
                commandArguments.add(strtok.nextToken());
            }
        } else if (this.arguments != null) {
            for (int i = 0; i < this.arguments.size(); ++i) {
                String arg;
                Object argument = this.arguments.get(i);
                if (argument == null) {
                    throw new MojoExecutionException("Misconfigured argument, value is null. Set the argument to an empty value if this is the required behaviour.");
                }
                if (argument instanceof Classpath) {
                    Classpath classpath = (Classpath)argument;
                    Collection artifacts = this.project.getArtifacts();
                    if (classpath.getDependencies() != null) {
                        artifacts = this.filterArtifacts(artifacts, classpath.getDependencies());
                    }
                    arg = this.computeClasspath(artifacts);
                } else {
                    arg = argument.toString();
                }
                commandArguments.add(arg);
            }
        }
        Commandline commandLine = new Commandline();
        commandLine.setExecutable(this.getExecutablePath());
        Iterator it = commandArguments.iterator();
        while (it.hasNext()) {
            commandLine.createArgument().setValue(it.next().toString());
        }
        if (this.workingDirectory == null) {
            this.workingDirectory = this.basedir;
        }
        if (!this.workingDirectory.exists()) {
            this.getLog().debug((CharSequence)("Making working directory '" + this.workingDirectory.getAbsolutePath() + "'."));
            if (!this.workingDirectory.mkdirs()) {
                throw new MojoExecutionException("Could not make working directory: '" + this.workingDirectory.getAbsolutePath() + "'");
            }
        }
        commandLine.setWorkingDirectory(this.workingDirectory.getAbsolutePath());
        StreamConsumer consumer = new StreamConsumer(){

            public void consumeLine(String line) {
                ExecMojo.this.getLog().info((CharSequence)line);
            }
        };
        try {
            int result = this.executeCommandLine(commandLine, consumer, consumer);
            if (result != 0) {
                throw new MojoExecutionException("Result of " + commandLine + " execution is: '" + result + "'.");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Command execution failed.", (Exception)((Object)e));
        }
        this.registerSourceRoots();
    }

    private String computeClasspath(Collection artifacts) {
        StringBuffer theClasspath = new StringBuffer();
        Iterator it = artifacts.iterator();
        while (it.hasNext()) {
            if (theClasspath.length() > 0) {
                theClasspath.append(File.pathSeparator);
            }
            Artifact artifact = (Artifact)it.next();
            this.getLog().debug((CharSequence)("dealing with " + artifact));
            theClasspath.append(artifact.getFile().getAbsolutePath());
        }
        if (theClasspath.length() > 0) {
            theClasspath.append(File.pathSeparator);
        }
        theClasspath.append(this.project.getBuild().getOutputDirectory());
        return theClasspath.toString();
    }

    private Collection filterArtifacts(Collection artifacts, Collection dependencies) {
        AndArtifactFilter filter = new AndArtifactFilter();
        filter.add((ArtifactFilter)new IncludesArtifactFilter(new ArrayList(dependencies)));
        StringBuffer theClasspath = new StringBuffer();
        ArrayList<Artifact> filteredArtifacts = new ArrayList<Artifact>();
        Iterator it = artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            if (!filter.include(artifact)) continue;
            this.getLog().debug((CharSequence)("filtering in " + artifact));
            filteredArtifacts.add(artifact);
        }
        return filteredArtifacts;
    }

    String getExecutablePath() {
        File execFile = new File(this.executable);
        if (execFile.exists()) {
            return execFile.getAbsolutePath();
        }
        this.getLog().debug((CharSequence)("executable " + this.executable + " not found in place, assuming it is in the PATH."));
        return this.executable;
    }

    private static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    protected int executeCommandLine(Commandline commandLine, StreamConsumer stream1, StreamConsumer stream2) throws CommandLineException {
        return CommandLineUtils.executeCommandLine((Commandline)commandLine, (StreamConsumer)stream1, (StreamConsumer)stream2);
    }

    void setExecutable(String executable) {
        this.executable = executable;
    }

    String getExecutable() {
        return this.executable;
    }

    void setWorkingDirectory(String workingDir) {
        this.setWorkingDirectory(new File(workingDir));
    }

    void setWorkingDirectory(File workingDir) {
        this.workingDirectory = workingDir;
    }

    void setArguments(List arguments) {
        this.arguments = arguments;
    }

    void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    void setProject(MavenProject project) {
        this.project = project;
    }

    protected String getSystemProperty(String key) {
        return System.getProperty(key);
    }
}

