/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dependency;

import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.dependency.AbstractFromConfigurationMojo;
import org.codehaus.mojo.dependency.ArtifactItem;
import org.codehaus.mojo.dependency.DependencyUtil;

public class CopyMojo
extends AbstractFromConfigurationMojo {
    private boolean stripVersion = false;

    public void execute() throws MojoExecutionException {
        ArrayList artifactItems = this.getArtifactItems();
        Iterator iter = ((AbstractList)artifactItems).iterator();
        while (iter.hasNext()) {
            ArtifactItem artifactItem = (ArtifactItem)iter.next();
            this.copyArtifact(artifactItem, this.stripVersion);
        }
    }

    protected void copyArtifact(ArtifactItem artifactItem, boolean removeVersion) throws MojoExecutionException {
        Artifact artifact = this.getArtifact(artifactItem);
        String destFileName = null;
        destFileName = artifactItem.getDestFileName() != null ? artifactItem.getDestFileName() : DependencyUtil.getFormattedFileName(artifact, removeVersion);
        File destFile = new File(artifactItem.getOutputDirectory(), destFileName);
        DependencyUtil.copyFile(artifact.getFile(), destFile, this.getLog());
    }
}

