/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.cassandra.AbstractCqlLoadMojo;
import org.codehaus.mojo.cassandra.Utils;

@Mojo(name="start", threadSafe=true, defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class StartCassandraMojo
extends AbstractCqlLoadMojo {
    @Parameter(defaultValue="180")
    protected int startWaitSeconds;
    @Parameter(property="cassandra.load.after.first.start", defaultValue="true")
    private boolean loadAfterFirstStart;
    @Parameter(property="cassandra.cu.load.failure.ignore")
    private boolean cuLoadFailureIgnore;
    @Parameter(property="cassandra.cu.load.after.first.start", defaultValue="true")
    private boolean cuLoadAfterFirstStart;
    @Parameter(property="cassandra.addJdk11Options", defaultValue="false")
    protected boolean addJdk11Options;

    @Override
    protected boolean useJdk11Options() {
        return this.addJdk11Options;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping cassandra: cassandra.skip==true");
            return;
        }
        long timeStamp = System.currentTimeMillis();
        boolean isClean = !this.cassandraDir.isDirectory();
        this.getLog().debug((CharSequence)((isClean ? "First start of Cassandra instance in " : "Re-using existing Cassandra instance in ") + this.cassandraDir.getAbsolutePath()));
        try {
            Utils.startCassandraServer(this.cassandraDir, this.newServiceCommandLine(), this.createEnvironmentVars(), this.getLog());
            if (this.startWaitSeconds >= 0) {
                this.getLog().info((CharSequence)"Waiting for Cassandra to start...");
                boolean started = Utils.waitUntilStarted(this.rpcAddress, this.nativeTransportPort, this.startWaitSeconds, this.getLog());
                if (!started) {
                    Utils.stopCassandraServer(this.rpcAddress, this.nativeTransportPort, this.listenAddress, this.stopPort, this.stopKey, this.getLog());
                    throw new MojoFailureException("Cassandra failed to start within " + this.startWaitSeconds + "s");
                }
            }
            if (isClean && this.loadAfterFirstStart) {
                this.execCqlFile();
            }
            this.getLog().info((CharSequence)("Cassandra started in " + (double)((System.currentTimeMillis() - timeStamp) / 100L) / 10.0 + "s"));
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
        }
    }
}

