/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.cassandra.AbstractSchemaCassandraMojo;
import org.codehaus.mojo.cassandra.CqlExecutionException;
import org.codehaus.mojo.cassandra.CqlOperation;

@Mojo(name="drop", threadSafe=true)
public class DropColumnFamiliesMojo
extends AbstractSchemaCassandraMojo {
    @Parameter(property="cassandra.columnFamilies")
    protected String columnFamilies;
    private String[] columnFamilyList;

    @Override
    protected CqlOperation buildOperation() {
        DropTableOperation dropTableOperation = new DropTableOperation(this.rpcAddress, this.nativeTransportPort);
        dropTableOperation.setKeyspace(this.keyspace);
        return dropTableOperation;
    }

    @Override
    protected void parseArguments() throws IllegalArgumentException {
        if (StringUtils.isNotBlank((CharSequence)this.keyspace)) {
            throw new IllegalArgumentException("The keyspace to drop column families from cannot be empty");
        }
        this.columnFamilyList = StringUtils.split((String)this.columnFamilies, (char)',');
    }

    class DropTableOperation
    extends CqlOperation {
        public DropTableOperation(String rpcAddress, int nativeTransportPort) {
            super(rpcAddress, nativeTransportPort);
        }

        @Override
        public void executeOperation(CqlSession cqlSession) throws CqlExecutionException {
            try {
                if (DropColumnFamiliesMojo.this.columnFamilyList != null && DropColumnFamiliesMojo.this.columnFamilyList.length > 0) {
                    for (String s : DropColumnFamiliesMojo.this.columnFamilyList) {
                        SchemaBuilder.dropTable((String)s).ifExists();
                        DropColumnFamiliesMojo.this.getLog().info((CharSequence)("Dropped Table \"" + s + "\"."));
                    }
                } else {
                    SchemaBuilder.dropKeyspace((String)DropColumnFamiliesMojo.this.keyspace).ifExists();
                    DropColumnFamiliesMojo.this.getLog().info((CharSequence)("Dropped keyspace \"" + DropColumnFamiliesMojo.this.keyspace + "\"."));
                }
            }
            catch (Exception e) {
                throw new CqlExecutionException(e);
            }
        }
    }
}

