/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildplan.display;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.mojo.buildplan.display.AbstractTableDescriptor;
import org.codehaus.mojo.buildplan.display.TableColumn;

public class ListTableDescriptor
extends AbstractTableDescriptor {
    private static final int ANSI_COLOR_CODES_LENGTH = MessageUtils.buffer().mojo((Object)"").toString().length();
    private int pluginSize;
    private int versionSize;
    private int phaseSize;
    private int lifecycleSize;
    private int executionIdSize;
    private int goalSize;

    public static ListTableDescriptor of(Collection<MojoExecution> executions, DefaultLifecycles defaultLifecycles) {
        Map<TableColumn, Integer> maxSize = ListTableDescriptor.findMaxSize(executions, defaultLifecycles, TableColumn.values());
        return new ListTableDescriptor().setPluginSize(maxSize.get((Object)TableColumn.ARTIFACT_ID)).setVersionSize(maxSize.get((Object)TableColumn.VERSION)).setPhaseSize(maxSize.get((Object)TableColumn.PHASE)).setLifecycleSize(maxSize.get((Object)TableColumn.LIFECYCLE)).setGoalSize(maxSize.get((Object)TableColumn.GOAL)).setExecutionIdSize(maxSize.get((Object)TableColumn.EXECUTION_ID));
    }

    @Override
    public String rowFormat() {
        return this.columns(this.getPluginSize());
    }

    private String columns(int pluginSize) {
        StringBuilder builder = new StringBuilder();
        if (this.lifecycleSize > 0) {
            builder.append("%-").append(this.getLifecycleSize()).append(FORMAT_STRING).append(" | ");
        }
        builder.append("%-").append(this.getPhaseSize()).append(FORMAT_STRING).append(" | ").append("%-").append(pluginSize).append(FORMAT_STRING).append(" | ").append("%-").append(this.getVersionSize()).append(FORMAT_STRING).append(" | ");
        builder.append("%-").append(this.getGoalSize()).append(FORMAT_STRING).append(" | ").append("%-").append(this.getExecutionIdSize()).append(FORMAT_STRING);
        return builder.toString();
    }

    public String titleFormat() {
        if (MessageUtils.isColorEnabled()) {
            return this.columns(this.getPluginSize() - ANSI_COLOR_CODES_LENGTH);
        }
        return this.columns(this.getPluginSize());
    }

    @Override
    public int width() {
        return this.withSeparator(this.getPluginSize(), this.getVersionSize(), this.getPhaseSize(), this.getLifecycleSize(), this.getExecutionIdSize(), this.getGoalSize());
    }

    private int withSeparator(int ... ints) {
        int width = Arrays.stream(ints).sum() + (ints.length - 1) * " | ".length();
        return MessageUtils.isColorEnabled() ? width - ANSI_COLOR_CODES_LENGTH : width;
    }

    public String toString() {
        return new StringJoiner(", ", ListTableDescriptor.class.getSimpleName() + "[", "]").add("Plugin column size=" + this.pluginSize).add("Plugin version size=" + this.versionSize).add("Phase column size=" + this.phaseSize).add("Lifecycle column size=" + this.lifecycleSize).add("Execution ID column size=" + this.executionIdSize).add("Goal column size=" + this.goalSize).add("width=" + this.width()).toString();
    }

    public int getPluginSize() {
        return this.pluginSize;
    }

    public ListTableDescriptor setPluginSize(int pluginSize) {
        this.pluginSize = pluginSize;
        return this;
    }

    private int getVersionSize() {
        return this.versionSize;
    }

    public ListTableDescriptor setVersionSize(int versionSize) {
        this.versionSize = versionSize;
        return this;
    }

    public int getPhaseSize() {
        return this.phaseSize;
    }

    public ListTableDescriptor setPhaseSize(int phaseSize) {
        this.phaseSize = phaseSize;
        return this;
    }

    public int getLifecycleSize() {
        return this.lifecycleSize;
    }

    public ListTableDescriptor setLifecycleSize(int lifecycleSize) {
        this.lifecycleSize = lifecycleSize;
        return this;
    }

    public int getExecutionIdSize() {
        return this.executionIdSize;
    }

    public ListTableDescriptor setExecutionIdSize(int executionIdSize) {
        this.executionIdSize = executionIdSize;
        return this;
    }

    public int getGoalSize() {
        return this.goalSize;
    }

    public ListTableDescriptor setGoalSize(int goalSize) {
        this.goalSize = goalSize;
        return this;
    }

    public void hideLifecycle() {
        this.lifecycleSize = -1 * " | ".length();
    }
}

