/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildplan;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.buildplan.AbstractLifecycleMojo;
import org.codehaus.mojo.buildplan.Groups;
import org.codehaus.mojo.buildplan.NoMojoExecution;
import org.codehaus.mojo.buildplan.display.ListPhaseTableDescriptor;
import org.codehaus.mojo.buildplan.display.MojoExecutionDisplay;
import org.codehaus.mojo.buildplan.display.Output;
import org.codehaus.mojo.buildplan.display.TableDescriptor;
import org.codehaus.mojo.buildplan.util.Multimap;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="list-phase", threadSafe=true)
public class ListPhaseMojo
extends AbstractLifecycleMojo {
    @Parameter(property="buildplan.phase")
    private String phase;
    @Parameter(property="buildplan.showLifecycles", defaultValue="false")
    private boolean showLifecycles;
    @Parameter(property="buildplan.showAllPhases", defaultValue="false")
    private boolean showAllPhases;

    @Override
    public void executeInternal() throws MojoFailureException {
        Multimap<String, MojoExecution> phases;
        Groups.Options options = new Groups.Options(this.defaultLifecycles);
        if (this.showAllPhases) {
            options = options.showingAllPhases();
        }
        if (this.showLifecycles) {
            options = options.showingLifecycles();
        }
        if (!(phases = Groups.ByPhase.of((List<MojoExecution>)this.calculateExecutionPlan().getMojoExecutions(), options)).isEmpty()) {
            ListPhaseTableDescriptor descriptor = ListPhaseTableDescriptor.of(phases.values(), this.defaultLifecycles);
            Lifecycle currentLifecycle = null;
            StringBuilder output = new StringBuilder();
            for (Map.Entry<String, Collection<MojoExecution>> currentPhase : phases.asMap().entrySet()) {
                if (this.showLifecycles) {
                    Lifecycle lifecycleForPhase = this.defaultLifecycles.get(currentPhase.getKey());
                    if (lifecycleForPhase == null) {
                        lifecycleForPhase = new Lifecycle("", Collections.emptyList(), Collections.emptyMap());
                    }
                    if (!lifecycleForPhase.equals(currentLifecycle)) {
                        currentLifecycle = lifecycleForPhase;
                        output.append(Output.lineSeparator()).append(Output.lineSeparator()).append("[").append(currentLifecycle.getId()).append("]");
                    }
                }
                output.append(Output.lineSeparator()).append(this.phaseTitleLine(descriptor, currentPhase.getKey()));
                currentPhase.getValue().stream().filter(execution -> execution != NoMojoExecution.INSTANCE).forEach(execution -> output.append(Output.lineSeparator()).append(this.line(descriptor.rowFormat(), (MojoExecution)execution)));
            }
            this.handleOutput(output.toString());
        } else {
            this.getLog().warn((CharSequence)("No plugin execution found within phase: " + this.phase));
        }
    }

    private String line(String rowFormat, MojoExecution execution) {
        MojoExecutionDisplay display = new MojoExecutionDisplay(execution);
        return String.format(rowFormat, display.getArtifactId(), display.getGoal(), display.getExecutionId());
    }

    private String phaseTitleLine(TableDescriptor descriptor, String key) {
        return key + " " + StringUtils.repeat((String)"-", (int)(descriptor.width() - key.length()));
    }
}

