/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildplan;

import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.buildplan.AbstractLifecycleMojo;
import org.codehaus.mojo.buildplan.display.ListTableDescriptor;
import org.codehaus.mojo.buildplan.display.MojoExecutionDisplay;
import org.codehaus.mojo.buildplan.display.Output;
import org.codehaus.mojo.buildplan.display.TableColumn;
import org.codehaus.mojo.buildplan.display.TableDescriptor;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="list", threadSafe=true)
public class ListMojo
extends AbstractLifecycleMojo {
    @Parameter(property="buildplan.showLifecycles", defaultValue="false")
    private boolean showLifecycles;

    @Override
    public void executeInternal() throws MojoFailureException {
        MavenExecutionPlan plan = this.calculateExecutionPlan();
        ListTableDescriptor descriptor = ListTableDescriptor.of(plan.getMojoExecutions(), this.defaultLifecycles);
        if (!this.showLifecycles) {
            descriptor.hideLifecycle();
        }
        String row = descriptor.rowFormat();
        String head = descriptor.titleFormat();
        StringBuilder output = new StringBuilder().append(Output.lineSeparator()).append(this.titleSeparator(descriptor)).append(Output.lineSeparator()).append(this.tableHead(head)).append(Output.lineSeparator()).append(this.titleSeparator(descriptor));
        for (MojoExecution execution : plan.getMojoExecutions()) {
            output.append(Output.lineSeparator()).append(this.tableRow(row, execution));
        }
        this.handleOutput(output.toString());
    }

    private String tableRow(String row, MojoExecution execution) {
        MojoExecutionDisplay display = new MojoExecutionDisplay(execution);
        if (this.showLifecycles) {
            return String.format(row, display.getLifecycle(this.defaultLifecycles), display.getPhase(), display.getArtifactId(), display.getVersion(), display.getGoal(), display.getExecutionId());
        }
        return String.format(row, display.getPhase(), display.getArtifactId(), display.getVersion(), display.getGoal(), display.getExecutionId());
    }

    private String tableHead(String row) {
        if (this.showLifecycles) {
            return String.format(row, TableColumn.LIFECYCLE.title(), TableColumn.PHASE.title(), TableColumn.ARTIFACT_ID.title(), TableColumn.VERSION.title(), TableColumn.GOAL.title(), TableColumn.EXECUTION_ID.title());
        }
        return String.format(row, TableColumn.PHASE.title(), TableColumn.ARTIFACT_ID.title(), TableColumn.VERSION.title(), TableColumn.GOAL.title(), TableColumn.EXECUTION_ID.title());
    }

    private String titleSeparator(TableDescriptor descriptor) {
        return StringUtils.repeat((String)"-", (int)descriptor.width());
    }
}

