/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildplan.display;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.codehaus.mojo.buildplan.display.TableColumn;
import org.codehaus.mojo.buildplan.display.TableDescriptor;
import org.codehaus.mojo.buildplan.util.LinkedMultimap;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractTableDescriptor
implements TableDescriptor {
    protected static Map<TableColumn, Integer> findMaxSize(Collection<MojoExecution> executions, DefaultLifecycles defaultLifecycles, TableColumn ... columns) {
        EnumMap<TableColumn, Integer> result = new EnumMap<TableColumn, Integer>(TableColumn.class);
        LinkedMultimap<TableColumn, Integer> count = new LinkedMultimap<TableColumn, Integer>();
        for (MojoExecution execution : executions) {
            block8: for (TableColumn column : columns) {
                switch (column) {
                    case ARTIFACT_ID: {
                        count.put(column, AbstractTableDescriptor.safeLength(execution.getArtifactId()));
                        continue block8;
                    }
                    case EXECUTION_ID: {
                        count.put(column, AbstractTableDescriptor.safeLength(execution.getExecutionId()));
                        continue block8;
                    }
                    case GOAL: {
                        count.put(column, AbstractTableDescriptor.safeLength(execution.getGoal()));
                        continue block8;
                    }
                    case PHASE: {
                        count.put(column, AbstractTableDescriptor.safeLength(AbstractTableDescriptor.phase(execution)));
                        continue block8;
                    }
                    case LIFECYCLE: {
                        Lifecycle lifecycle = defaultLifecycles.get(AbstractTableDescriptor.phase(execution));
                        count.put(column, lifecycle == null ? 0 : AbstractTableDescriptor.safeLength(lifecycle.getId()));
                    }
                }
            }
        }
        for (TableColumn column : TableColumn.values()) {
            count.put(column, column.title().length());
        }
        for (TableColumn key : count.keySet()) {
            result.put(key, (Integer)Collections.max(count.get(key)));
        }
        return result;
    }

    public static String phase(MojoExecution execution) {
        MojoDescriptor mojoDescriptor = execution.getMojoDescriptor();
        if (mojoDescriptor != null && mojoDescriptor.getPhase() != null) {
            return mojoDescriptor.getPhase();
        }
        return execution.getLifecyclePhase();
    }

    private static int safeLength(String string) {
        return StringUtils.defaultString((Object)string).length();
    }
}

