/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildplan;

import java.util.Collection;
import java.util.Map;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.buildplan.AbstractLifecycleMojo;
import org.codehaus.mojo.buildplan.Groups;
import org.codehaus.mojo.buildplan.display.ListPluginTableDescriptor;
import org.codehaus.mojo.buildplan.display.MojoExecutionDisplay;
import org.codehaus.mojo.buildplan.display.Output;
import org.codehaus.mojo.buildplan.display.TableDescriptor;
import org.codehaus.mojo.buildplan.util.Multimap;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="list-plugin", threadSafe=true)
public class ListPluginMojo
extends AbstractLifecycleMojo {
    @Parameter(property="buildplan.plugin")
    private String plugin;

    @Override
    public void executeInternal() throws MojoFailureException {
        Multimap<String, MojoExecution> plan = Groups.ByPlugin.of(this.calculateExecutionPlan().getMojoExecutions(), this.plugin);
        if (plan.isEmpty()) {
            this.getLog().warn((CharSequence)("No plugin found with artifactId: " + this.plugin));
        } else {
            StringBuilder output = new StringBuilder();
            ListPluginTableDescriptor descriptor = ListPluginTableDescriptor.of(plan.values(), this.defaultLifecycles);
            for (Map.Entry<String, Collection<MojoExecution>> executions : plan.asMap().entrySet()) {
                output.append(Output.lineSeparator()).append(this.pluginTitleLine(descriptor, executions.getKey()));
                for (MojoExecution execution : executions.getValue()) {
                    output.append(Output.lineSeparator()).append(this.line(descriptor.rowFormat(), execution));
                }
            }
            this.handleOutput(output.toString());
        }
    }

    private String line(String rowFormat, MojoExecution execution) {
        MojoExecutionDisplay display = new MojoExecutionDisplay(execution);
        return String.format(rowFormat, display.getPhase(), display.getExecutionId(), display.getGoal());
    }

    private String pluginTitleLine(TableDescriptor descriptor, String key) {
        return key + " " + StringUtils.repeat((String)"-", (int)(descriptor.width() - key.length()));
    }
}

