/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.aspectj;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.MessageHandler;

public class MavenMessageHandler
extends MessageHandler {
    private static final List<IMessage.Kind> DEFAULT_DETAIL_TYPES = new ArrayList<IMessage.Kind>();
    private Log log;
    private List<IMessage.Kind> showDetailsForMessageKindList;

    public MavenMessageHandler(Log log, List<IMessage.Kind> showDetailsForMessageKindList) {
        if (log == null) {
            throw new NullPointerException("Cannot handle null log argument.");
        }
        if (showDetailsForMessageKindList == null) {
            throw new NullPointerException("Cannot handle null showDetailsForMessageKindList argument.");
        }
        this.log = log;
        this.showDetailsForMessageKindList = showDetailsForMessageKindList;
        if (log.isInfoEnabled()) {
            log.info((CharSequence)("Showing AJC message detail for messages of types: " + showDetailsForMessageKindList));
        }
    }

    public MavenMessageHandler(Log log) {
        this(log, DEFAULT_DETAIL_TYPES);
    }

    public boolean handleMessage(IMessage message) {
        StringBuilder builder = new StringBuilder(message.getMessage());
        if (this.isMessageDetailDesired(message)) {
            ISourceLocation sourceLocation = message.getSourceLocation();
            String sourceFile = sourceLocation == null || sourceLocation.getSourceFile() == null ? "<unknown source file>" : sourceLocation.getSourceFile().getAbsolutePath();
            String context = sourceLocation == null || sourceLocation.getContext() == null ? "" : sourceLocation.getContext() + "\n";
            String line = sourceLocation == null ? "<no line information>" : "" + sourceLocation.getLine();
            builder.append("\n\t").append(sourceFile).append(":").append(line).append("\n").append(context);
        }
        String messageText = builder.toString();
        if (this.isNotIgnored(message, IMessage.DEBUG) || this.isNotIgnored(message, IMessage.INFO) || this.isNotIgnored(message, IMessage.TASKTAG)) {
            this.log.debug((CharSequence)messageText);
        } else if (this.isNotIgnored(message, IMessage.WEAVEINFO)) {
            this.log.info((CharSequence)messageText);
        } else if (this.isNotIgnored(message, IMessage.WARNING)) {
            this.log.warn((CharSequence)messageText);
        } else if (this.isNotIgnored(message, IMessage.ERROR) || this.isNotIgnored(message, IMessage.ABORT) || this.isNotIgnored(message, IMessage.FAIL)) {
            this.log.error((CharSequence)messageText);
        }
        return super.handleMessage(message);
    }

    private boolean isMessageDetailDesired(IMessage message) {
        if (message != null) {
            for (IMessage.Kind current : this.showDetailsForMessageKindList) {
                if (!message.getKind().equals(current)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNotIgnored(IMessage message, IMessage.Kind messageType) {
        return message.getKind().equals(messageType) && !this.isIgnoring(messageType);
    }

    static {
        DEFAULT_DETAIL_TYPES.add(IMessage.ERROR);
        DEFAULT_DETAIL_TYPES.add(IMessage.WARNING);
        DEFAULT_DETAIL_TYPES.add(IMessage.FAIL);
    }
}

