/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.antlr;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.wagon.PathUtils;
import org.codehaus.mojo.antlr.AbstractAntlrMojo;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class AntlrHtmlReport
extends AbstractAntlrMojo
implements MavenReport {
    private Renderer siteRenderer;
    protected I18N i18n;
    private File reportOutputDirectory;
    private String name;
    private String description;

    public String getName(Locale locale) {
        if (StringUtils.isEmpty((String)this.name)) {
            return this.i18n.getString("antlr-report", locale, "report.name");
        }
        return "Antlr Grammars";
    }

    public String getDescription(Locale locale) {
        if (StringUtils.isEmpty((String)this.description)) {
            return this.i18n.getString("antlr-report", locale, "report.description");
        }
        return this.description;
    }

    protected void addArgs(List arguments) {
        arguments.add("-html");
    }

    public void generate(org.codehaus.doxia.sink.Sink sink, Locale locale) throws MavenReportException {
        this.outputDirectory = this.getReportOutputDirectory();
        try {
            this.executeAntlr();
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException("Antlr execution failed: " + e.getMessage(), (Exception)((Object)e));
        }
        AntlrRenderer r = new AntlrRenderer(sink, this.outputDirectory, this.i18n, Locale.ENGLISH);
        r.render();
    }

    public String getOutputName() {
        return "antlr/index";
    }

    public boolean isExternalReport() {
        return false;
    }

    public boolean canGenerateReport() {
        return true;
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public File getReportOutputDirectory() {
        if (this.reportOutputDirectory == null) {
            return this.outputDirectory;
        }
        return this.reportOutputDirectory;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.reportOutputDirectory = reportOutputDirectory != null && !reportOutputDirectory.getAbsolutePath().endsWith("antlr") ? new File(reportOutputDirectory, "antlr") : reportOutputDirectory;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            SiteRendererSink sink = this.siteRenderer.createSink(this.getReportOutputDirectory(), this.getOutputName() + ".html");
            this.generate((org.codehaus.doxia.sink.Sink)sink, Locale.getDefault());
        }
        catch (RendererException e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)e);
        }
        catch (MavenReportException e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)((Object)e));
        }
    }

    private static class AntlrRenderer
    extends AbstractMavenReportRenderer {
        private File outputDirectory;
        private I18N i18n;
        private Locale locale;

        AntlrRenderer(org.codehaus.doxia.sink.Sink sink, File outputDirectory, I18N i18n, Locale locale) {
            super((Sink)sink);
            this.outputDirectory = outputDirectory;
            this.i18n = i18n;
            this.locale = locale;
        }

        public String getTitle() {
            return this.i18n.getString("antlr-report", this.locale, "report.title");
        }

        public void renderBody() {
            this.startSection(this.i18n.getString("antlr-report", this.locale, "report.overview.title"));
            this.paragraph(this.i18n.getString("antlr-report", this.locale, "report.overview.intro"));
            this.endSection();
            this.startSection(this.i18n.getString("antlr-report", this.locale, "report.grammars.title"));
            try {
                List htmlFiles = FileUtils.getFiles((File)this.outputDirectory, (String)"**/*.html", (String)"**/*index.html");
                if (htmlFiles.isEmpty()) {
                    this.sink.text(this.i18n.getString("antlr-report", this.locale, "report.grammars.noreport"));
                } else {
                    this.sink.list();
                    Iterator it = htmlFiles.iterator();
                    while (it.hasNext()) {
                        File current = (File)it.next();
                        this.sink.listItem();
                        this.sink.link(PathUtils.toRelative((File)this.outputDirectory, (String)current.getAbsolutePath()));
                        this.sink.text(StringUtils.replace((String)current.getName(), (String)".html", (String)""));
                        this.sink.link_();
                        this.sink.listItem_();
                    }
                    this.sink.list_();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("IOException: " + e.getMessage(), e);
            }
            this.endSection();
            this.sink.flush();
            this.sink.close();
        }
    }
}

