/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.xpp3;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Properties;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.generator.java.javasource.JClass;
import org.codehaus.modello.generator.java.javasource.JField;
import org.codehaus.modello.generator.java.javasource.JMethod;
import org.codehaus.modello.generator.java.javasource.JParameter;
import org.codehaus.modello.generator.java.javasource.JSourceCode;
import org.codehaus.modello.generator.java.javasource.JSourceWriter;
import org.codehaus.modello.generator.java.javasource.JType;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.AbstractModelloGenerator;
import org.codehaus.modello.plugin.java.JavaFieldMetadata;
import org.codehaus.modello.plugin.model.ModelClassMetadata;
import org.codehaus.modello.plugin.xpp3.AbstractXpp3Generator;
import org.codehaus.modello.plugins.xml.XmlAssociationMetadata;
import org.codehaus.modello.plugins.xml.XmlFieldMetadata;

public class Xpp3WriterGenerator
extends AbstractXpp3Generator {
    public void generate(Model model, Properties properties) throws ModelloException {
        this.initialize(model, properties);
        try {
            this.generateXpp3Writer(model);
        }
        catch (IOException iOException) {
            throw new ModelloException("Exception while generating XPP3 Writer.", (Throwable)iOException);
        }
    }

    private void generateXpp3Writer(Model model) throws ModelloException, IOException {
        Model model2 = this.getModel();
        String string = this.isPackageWithVersion() ? model2.getPackageName(true, this.getGeneratedVersion()) : model2.getPackageName(false, null);
        string = String.valueOf(string) + ".io.xpp3";
        String string2 = string.replace('.', '/');
        String string3 = this.getFileName("Xpp3Writer");
        File file = new File(new File(this.getOutputDirectory(), string2), String.valueOf(string3) + ".java");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileWriter fileWriter = new FileWriter(file);
        JSourceWriter jSourceWriter = new JSourceWriter((Writer)fileWriter);
        JClass jClass = new JClass(string3);
        jClass.setPackageName(string);
        jClass.addImport("org.codehaus.plexus.util.xml.*");
        jClass.addImport("org.codehaus.plexus.util.xml.pull.*");
        jClass.addImport("java.io.Writer");
        jClass.addImport("java.util.Iterator");
        jClass.addField(new JField((JType)new JClass("org.codehaus.plexus.util.xml.pull.XmlSerializer"), "serializer"));
        jClass.addField(new JField((JType)new JClass("String"), "NAMESPACE"));
        this.addModelImports(jClass, null);
        String string4 = model2.getRoot(this.getGeneratedVersion());
        ModelClass modelClass = model2.getClass(string4, this.getGeneratedVersion());
        ModelClassMetadata modelClassMetadata = (ModelClassMetadata)modelClass.getMetadata(ModelClassMetadata.ID);
        String string5 = modelClassMetadata == null || modelClassMetadata.getTagName() == null ? AbstractModelloGenerator.uncapitalise((String)string4) : modelClassMetadata.getTagName();
        JMethod jMethod = new JMethod(null, "write");
        jMethod.addParameter(new JParameter((JType)new JClass("Writer"), "writer"));
        jMethod.addParameter(new JParameter((JType)new JClass(string4), string5));
        jMethod.addException(new JClass("Exception"));
        JSourceCode jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("serializer = new MXSerializer();");
        jSourceCode.add("serializer.setProperty( \"http://xmlpull.org/v1/doc/properties.html#serializer-indentation\", \"  \" );");
        jSourceCode.add("serializer.setProperty( \"http://xmlpull.org/v1/doc/properties.html#serializer-line-separator\", \"\\n\" );");
        jSourceCode.add("serializer.setOutput( writer );");
        jSourceCode.add("write" + string4 + "( " + string5 + ", \"" + string5 + "\", serializer );");
        jClass.addMethod(jMethod);
        this.writeAllClasses(model2, jClass);
        jClass.print(jSourceWriter);
        fileWriter.flush();
        fileWriter.close();
    }

    private String getPrefix(JavaFieldMetadata javaFieldMetadata) {
        return javaFieldMetadata.isBooleanGetter() ? "is" : "get";
    }

    private String getValue(String string, String string2) {
        String string3 = string2;
        if (!"String".equals(string)) {
            string3 = "String.valueOf( " + string3 + " )";
        }
        return string3;
    }

    private String getValueChecker(String string, String string2, ModelField modelField) {
        if ("boolean".equals(string) || "double".equals(string) || "float".equals(string) || "int".equals(string) || "long".equals(string) || "short".equals(string)) {
            return "if ( " + string2 + " != " + modelField.getDefaultValue() + " )";
        }
        if ("char".equals(string)) {
            return "if ( " + string2 + " != '" + modelField.getDefaultValue() + "' )";
        }
        if ("java.util.List".equals(string) || "java.util.Set".equals(string) || "java.util.Map".equals(string) || "java.util.Properties".equals(string)) {
            return "if ( " + string2 + " != null && " + string2 + ".size() > 0 )";
        }
        if ("String".equals(string) && modelField.getDefaultValue() != null) {
            return "if ( " + string2 + " != null && !" + string2 + ".equals( \"" + modelField.getDefaultValue() + "\" ) )";
        }
        return "if ( " + string2 + " != null )";
    }

    private void writeAllClasses(Model model, JClass jClass) {
        Iterator iterator = model.getClasses(this.getGeneratedVersion()).iterator();
        while (iterator.hasNext()) {
            ModelClass modelClass = (ModelClass)iterator.next();
            this.writeClass(modelClass, jClass);
        }
    }

    private void writeClass(ModelClass modelClass, JClass jClass) {
        String string;
        String string2;
        String string3;
        JavaFieldMetadata javaFieldMetadata;
        XmlFieldMetadata xmlFieldMetadata;
        Object object;
        String string4 = modelClass.getName();
        String string5 = AbstractModelloGenerator.uncapitalise((String)string4);
        JMethod jMethod = new JMethod(null, "write" + string4);
        jMethod.addParameter(new JParameter((JType)new JClass(string4), string5));
        jMethod.addParameter(new JParameter((JType)new JClass("String"), "tagName"));
        jMethod.addParameter(new JParameter((JType)new JClass("XmlSerializer"), "serializer"));
        jMethod.addException(new JClass("Exception"));
        jMethod.getModifiers().makePrivate();
        JSourceCode jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("if ( " + string5 + " != null )");
        jSourceCode.add("{");
        jSourceCode.indent();
        jSourceCode.add("serializer.startTag( NAMESPACE, tagName );");
        Iterator iterator = modelClass.getAllFields(this.getGeneratedVersion(), true).iterator();
        while (iterator.hasNext()) {
            object = (ModelField)iterator.next();
            xmlFieldMetadata = (XmlFieldMetadata)object.getMetadata(XmlFieldMetadata.ID);
            javaFieldMetadata = (JavaFieldMetadata)object.getMetadata(JavaFieldMetadata.ID);
            string3 = xmlFieldMetadata.getTagName();
            if (string3 == null) {
                string3 = object.getName();
            }
            string2 = object.getType();
            string = String.valueOf(string5) + "." + this.getPrefix(javaFieldMetadata) + this.capitalise(object.getName()) + "()";
            if (!xmlFieldMetadata.isAttribute()) continue;
            jSourceCode.add(this.getValueChecker(string2, string, (ModelField)object));
            jSourceCode.add("{");
            jSourceCode.indent();
            jSourceCode.add("serializer.attribute( NAMESPACE, \"" + string3 + "\", " + this.getValue(object.getType(), string) + " );");
            jSourceCode.unindent();
            jSourceCode.add("}");
        }
        object = modelClass.getAllFields(this.getGeneratedVersion(), true).iterator();
        while (object.hasNext()) {
            xmlFieldMetadata = (ModelField)object.next();
            javaFieldMetadata = (XmlFieldMetadata)xmlFieldMetadata.getMetadata(XmlFieldMetadata.ID);
            string3 = (JavaFieldMetadata)xmlFieldMetadata.getMetadata(JavaFieldMetadata.ID);
            string2 = javaFieldMetadata.getTagName();
            if (string2 == null) {
                string2 = xmlFieldMetadata.getName();
            }
            if ((string = javaFieldMetadata.getAssociationTagName()) == null) {
                string = this.singular(string2);
            }
            boolean bl = "wrapped".equals(javaFieldMetadata.getListStyle());
            String string6 = xmlFieldMetadata.getType();
            String string7 = String.valueOf(string5) + "." + this.getPrefix((JavaFieldMetadata)string3) + this.capitalise(xmlFieldMetadata.getName()) + "()";
            if (javaFieldMetadata.isAttribute()) continue;
            if (xmlFieldMetadata instanceof ModelAssociation) {
                ModelAssociation modelAssociation = (ModelAssociation)xmlFieldMetadata;
                String string8 = modelAssociation.getName();
                if ("1".equals(modelAssociation.getMultiplicity())) {
                    jSourceCode.add(this.getValueChecker(string6, string7, (ModelField)modelAssociation));
                    jSourceCode.add("{");
                    jSourceCode.indent();
                    jSourceCode.add("write" + modelAssociation.getTo() + "( " + string7 + ", \"" + string2 + "\", serializer );");
                    jSourceCode.unindent();
                    jSourceCode.add("}");
                    continue;
                }
                string6 = modelAssociation.getType();
                String string9 = modelAssociation.getTo();
                if ("java.util.List".equals(string6) || "java.util.Set".equals(string6)) {
                    jSourceCode.add(this.getValueChecker(string6, string7, (ModelField)modelAssociation));
                    jSourceCode.add("{");
                    jSourceCode.indent();
                    if (bl) {
                        jSourceCode.add("serializer.startTag( NAMESPACE, \"" + string2 + "\" );");
                    }
                    jSourceCode.add("for ( Iterator iter = " + string7 + ".iterator(); iter.hasNext(); )");
                    jSourceCode.add("{");
                    jSourceCode.indent();
                    if (this.isClassInModel(modelAssociation.getTo(), modelClass.getModel())) {
                        jSourceCode.add(String.valueOf(string9) + " " + AbstractModelloGenerator.uncapitalise((String)string9) + " = (" + string9 + ") iter.next();");
                        jSourceCode.add("write" + string9 + "( " + AbstractModelloGenerator.uncapitalise((String)string9) + ", \"" + string + "\", serializer );");
                    } else {
                        jSourceCode.add(String.valueOf(string9) + " " + this.singular(AbstractModelloGenerator.uncapitalise((String)xmlFieldMetadata.getName())) + " = (" + string9 + ") iter.next();");
                        jSourceCode.add("serializer.startTag( NAMESPACE, \"" + string + "\" ).text( " + this.singular(AbstractModelloGenerator.uncapitalise((String)xmlFieldMetadata.getName())) + " ).endTag( NAMESPACE, " + "\"" + string + "\" );");
                    }
                    jSourceCode.unindent();
                    jSourceCode.add("}");
                    if (bl) {
                        jSourceCode.add("serializer.endTag( NAMESPACE, \"" + string2 + "\" );");
                    }
                    jSourceCode.unindent();
                    jSourceCode.add("}");
                    continue;
                }
                XmlAssociationMetadata xmlAssociationMetadata = (XmlAssociationMetadata)modelAssociation.getAssociationMetadata(XmlAssociationMetadata.ID);
                jSourceCode.add(this.getValueChecker(string6, string7, (ModelField)xmlFieldMetadata));
                jSourceCode.add("{");
                jSourceCode.indent();
                if (bl) {
                    jSourceCode.add("serializer.startTag( NAMESPACE, \"" + string2 + "\" );");
                }
                jSourceCode.add("for ( Iterator iter = " + string7 + ".keySet().iterator(); iter.hasNext(); )");
                jSourceCode.add("{");
                jSourceCode.indent();
                jSourceCode.add("String key = (String) iter.next();");
                jSourceCode.add("String value = (String) " + string7 + ".get( key );");
                if ("explode".equals(xmlAssociationMetadata.getMapStyle())) {
                    jSourceCode.add("serializer.startTag( NAMESPACE, \"" + this.singular(string8) + "\" );");
                    jSourceCode.add("serializer.startTag( NAMESPACE, \"key\" ).text( key ).endTag( NAMESPACE, \"key\" );");
                    jSourceCode.add("serializer.startTag( NAMESPACE, \"value\" ).text( value ).endTag( NAMESPACE, \"value\" );");
                    jSourceCode.add("serializer.endTag( NAMESPACE, \"" + this.singular(string8) + "\" );");
                } else {
                    jSourceCode.add("serializer.startTag( NAMESPACE, \"\" + key + \"\" ).text( value ).endTag( NAMESPACE, \"\" + key + \"\" );");
                }
                jSourceCode.unindent();
                jSourceCode.add("}");
                if (bl) {
                    jSourceCode.add("serializer.endTag( NAMESPACE, \"" + string2 + "\" );");
                }
                jSourceCode.unindent();
                jSourceCode.add("}");
                continue;
            }
            jSourceCode.add(this.getValueChecker(string6, string7, (ModelField)xmlFieldMetadata));
            jSourceCode.add("{");
            jSourceCode.indent();
            if ("DOM".equals(xmlFieldMetadata.getType())) {
                jSourceCode.add("((Xpp3Dom) " + string7 + ").writeToSerializer( NAMESPACE, serializer );");
            } else {
                jSourceCode.add("serializer.startTag( NAMESPACE, \"" + string2 + "\" ).text( " + this.getValue(xmlFieldMetadata.getType(), string7) + " ).endTag( NAMESPACE, " + "\"" + string2 + "\" );");
            }
            jSourceCode.unindent();
            jSourceCode.add("}");
        }
        jSourceCode.add("serializer.endTag( NAMESPACE, tagName );");
        jSourceCode.unindent();
        jSourceCode.add("}");
        jClass.addMethod(jMethod);
    }
}

