/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler.util.resource;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.commons.compiler.util.resource.FileResource;
import org.codehaus.commons.compiler.util.resource.FileResourceFinder;
import org.codehaus.commons.compiler.util.resource.Resource;
import org.codehaus.commons.nullanalysis.Nullable;

public class DirectoryResourceFinder
extends FileResourceFinder {
    private final File directory;
    private final Map<String, Set<File>> subdirectoryNameToFiles = new HashMap<String, Set<File>>();

    public DirectoryResourceFinder(File directory) {
        this.directory = directory;
    }

    public final String toString() {
        return "dir:" + this.directory;
    }

    @Override
    @Nullable
    protected final File findResourceAsFile(String resourceName) {
        int idx = resourceName.lastIndexOf(47);
        String subdirectoryName = idx == -1 ? null : resourceName.substring(0, idx).replace('/', File.separatorChar);
        Set<File> files = this.listFiles(subdirectoryName);
        if (files == null) {
            return null;
        }
        File file = new File(this.directory, resourceName.replace('/', File.separatorChar));
        if (!files.contains(file)) {
            return null;
        }
        return file;
    }

    @Nullable
    private Set<File> listFiles(@Nullable String subdirectoryName) {
        Set<File> files = this.subdirectoryNameToFiles.get(subdirectoryName);
        if (files == null && !this.subdirectoryNameToFiles.containsKey(subdirectoryName)) {
            File subDirectory = subdirectoryName == null || subdirectoryName.isEmpty() ? this.directory : new File(this.directory, subdirectoryName);
            File[] fa = subDirectory.listFiles();
            if (fa != null) {
                files = new HashSet<File>();
                for (File file : fa) {
                    if (!file.isFile()) continue;
                    files.add(file);
                }
            }
            this.subdirectoryNameToFiles.put(subdirectoryName, files);
        }
        return files;
    }

    @Override
    @Nullable
    public Iterable<Resource> list(String resourceNamePrefix, boolean recurse) {
        Set<File> files = this.listFiles(resourceNamePrefix.replace('/', File.separatorChar));
        if (files == null) {
            return null;
        }
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (File f : files) {
            result.add(new FileResource(f));
        }
        return result;
    }
}

