/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.Currency;
import java.util.HashMap;
import java.util.UUID;
import java.util.regex.Pattern;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.ser.SerializerBase;
import org.codehaus.jackson.map.ser.ToStringSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JdkSerializers {
    static void addAll(HashMap<String, JsonSerializer<?>> sers) {
        sers.put(File.class.getName(), new FileSerializer());
        ToStringSerializer sls = ToStringSerializer.instance;
        sers.put(URL.class.getName(), sls);
        sers.put(URI.class.getName(), sls);
        sers.put(Currency.class.getName(), sls);
        sers.put(UUID.class.getName(), sls);
        sers.put(Pattern.class.getName(), sls);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FileSerializer
    extends SerializerBase<File> {
        @Override
        public void serialize(File value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeString(value.getAbsolutePath());
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            return this.createSchemaNode("string", true);
        }
    }
}

